/*
 * Decompiled with CFR 0.152.
 */
package com.bmuschko.gradle.docker.tasks.container;

import com.bmuschko.gradle.docker.internal.CopyUtils;
import com.bmuschko.gradle.docker.tasks.container.DockerExistingContainer;
import com.github.dockerjava.api.command.CopyArchiveFromContainerCmd;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.file.ArchiveOperations;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.FileSystemOperations;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;

public class DockerCopyFileFromContainer
extends DockerExistingContainer {
    private final Property<String> remotePath;
    private final Property<String> hostPath;
    private final Property<Boolean> compressed;
    private final FileSystemOperations fileSystemOperations;
    private final ArchiveOperations archiveOperations;

    @Input
    public final Property<String> getRemotePath() {
        return this.remotePath;
    }

    @Input
    public final Property<String> getHostPath() {
        return this.hostPath;
    }

    @Input
    @Optional
    public final Property<Boolean> getCompressed() {
        return this.compressed;
    }

    @Inject
    public DockerCopyFileFromContainer(ObjectFactory objects, ProjectLayout layout, FileSystemOperations fileSystemOperations, ArchiveOperations archiveOperations) {
        this.remotePath = objects.property(String.class);
        this.hostPath = objects.property(String.class).convention((Object)layout.getProjectDirectory().getAsFile().getPath());
        this.compressed = objects.property(Boolean.class).convention((Object)false);
        this.fileSystemOperations = fileSystemOperations;
        this.archiveOperations = archiveOperations;
    }

    @Override
    public void runRemoteCommand() throws IOException {
        CopyArchiveFromContainerCmd containerCommand = this.getDockerClient().copyArchiveFromContainerCmd((String)this.getContainerId().get(), (String)this.remotePath.get());
        this.getLogger().quiet("Copying '" + (String)this.getRemotePath().get() + "' from container with ID '" + (String)this.getContainerId().get() + "' to '" + (String)this.getHostPath().get() + "'.");
        try (InputStream tarStream = containerCommand.exec();){
            if (this.getNextHandler() != null) {
                this.getNextHandler().execute((Object)tarStream);
            } else {
                Path hostDestination = Paths.get((String)this.hostPath.get(), new String[0]);
                if (Boolean.TRUE.equals(this.compressed.getOrNull())) {
                    this.copyFileCompressed(tarStream, hostDestination);
                } else {
                    this.copyFile(tarStream, hostDestination);
                }
            }
        }
    }

    private void copyFileCompressed(InputStream tarStream, Path hostDestination) throws IOException {
        Path compressedFileLocation;
        String fileName = (String)this.remotePath.get();
        String compressedFileName = Files.exists(hostDestination, new LinkOption[0]) && Files.isDirectory(hostDestination, new LinkOption[0]) ? (fileName.endsWith(".tar") ? fileName : fileName + ".tar") : hostDestination.getFileName().toString();
        Path path = compressedFileLocation = Files.exists(hostDestination, new LinkOption[0]) && Files.isDirectory(hostDestination, new LinkOption[0]) ? hostDestination : hostDestination.getParent();
        if (Files.exists(hostDestination, new LinkOption[0])) {
            if (!Files.isDirectory(hostDestination, new LinkOption[0])) {
                Files.delete(hostDestination);
            }
        } else if (!Files.exists(hostDestination.getParent(), new LinkOption[0])) {
            Files.createDirectories(hostDestination.getParent(), new FileAttribute[0]);
        }
        Path tarFile = compressedFileLocation.resolve(compressedFileName);
        try (OutputStream out = Files.newOutputStream(tarFile, new OpenOption[0]);){
            tarStream.transferTo(out);
        }
    }

    private void copyFile(InputStream tarStream, Path hostDestination) throws IOException {
        long fileCount;
        Path tempDestination = this.untarStream(tarStream);
        try (Stream<Path> stream = Files.walk(tempDestination, new FileVisitOption[0]);){
            fileCount = stream.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).count();
        }
        if (fileCount == 0L) {
            this.getLogger().quiet("Nothing to copy.");
        } else if (fileCount == 1L) {
            CopyUtils.copySingleFile(hostDestination, tempDestination);
        } else {
            CopyUtils.copyMultipleFiles(hostDestination, tempDestination);
        }
    }

    private Path untarStream(InputStream tarStream) throws IOException {
        Path tempFile = this.getTemporaryDir().toPath().resolve(UUID.randomUUID().toString() + ".tar");
        try (OutputStream out = Files.newOutputStream(tempFile, new OpenOption[0]);){
            tarStream.transferTo(out);
        }
        final Path outputDirectory = this.getTemporaryDir().toPath().resolve(UUID.randomUUID().toString());
        Files.createDirectories(outputDirectory, new FileAttribute[0]);
        final FileTree tarTree = this.archiveOperations.tarTree((Object)tempFile);
        this.fileSystemOperations.copy((Action)new Action<CopySpec>(){

            public void execute(CopySpec copySpec) {
                copySpec.into((Object)outputDirectory);
                copySpec.from(new Object[]{tarTree});
            }
        });
        return outputDirectory;
    }
}

