/*
 * Decompiled with CFR 0.152.
 */
package com.bmuschko.gradle.docker.shaded.org.bouncycastle.jcajce.provider.digest;

import com.bmuschko.gradle.docker.shaded.org.bouncycastle.asn1.teletrust.TeleTrusTObjectIdentifiers;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.crypto.CipherKeyGenerator;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.crypto.digests.RIPEMD160Digest;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.crypto.macs.HMac;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.internal.asn1.iana.IANAObjectIdentifiers;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.jcajce.provider.digest.BCMessageDigest;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.jcajce.provider.digest.DigestAlgorithmProvider;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.jcajce.provider.symmetric.util.BaseKeyGenerator;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.jcajce.provider.symmetric.util.BaseMac;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.jcajce.provider.symmetric.util.PBESecretKeyFactory;

public class RIPEMD160 {
    private RIPEMD160() {
    }

    public static class Digest
    extends BCMessageDigest
    implements Cloneable {
        public Digest() {
            super(new RIPEMD160Digest());
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            Digest digest = (Digest)super.clone();
            digest.digest = new RIPEMD160Digest((RIPEMD160Digest)this.digest);
            return digest;
        }
    }

    public static class HashMac
    extends BaseMac {
        public HashMac() {
            super(new HMac(new RIPEMD160Digest()));
        }
    }

    public static class KeyGenerator
    extends BaseKeyGenerator {
        public KeyGenerator() {
            super("HMACRIPEMD160", 160, new CipherKeyGenerator());
        }
    }

    public static class Mappings
    extends DigestAlgorithmProvider {
        private static final String PREFIX = RIPEMD160.class.getName();

        @Override
        public void configure(ConfigurableProvider configurableProvider) {
            configurableProvider.addAlgorithm("MessageDigest.RIPEMD160", PREFIX + "$Digest");
            configurableProvider.addAlgorithm("Alg.Alias.MessageDigest." + TeleTrusTObjectIdentifiers.ripemd160, "RIPEMD160");
            this.addHMACAlgorithm(configurableProvider, "RIPEMD160", PREFIX + "$HashMac", PREFIX + "$KeyGenerator");
            this.addHMACAlias(configurableProvider, "RIPEMD160", IANAObjectIdentifiers.hmacRIPEMD160);
            configurableProvider.addAlgorithm("SecretKeyFactory.PBEWITHHMACRIPEMD160", PREFIX + "$PBEWithHmacKeyFactory");
            configurableProvider.addAlgorithm("Mac.PBEWITHHMACRIPEMD160", PREFIX + "$PBEWithHmac");
        }
    }

    public static class PBEWithHmac
    extends BaseMac {
        public PBEWithHmac() {
            super(new HMac(new RIPEMD160Digest()), 2, 2, 160);
        }
    }

    public static class PBEWithHmacKeyFactory
    extends PBESecretKeyFactory {
        public PBEWithHmacKeyFactory() {
            super("PBEwithHmacRIPEMD160", null, false, 2, 2, 160, 0);
        }
    }
}

