/*
 * Decompiled with CFR 0.152.
 */
package com.bmuschko.gradle.docker.shaded.org.bouncycastle.asn1.cmc;

import com.bmuschko.gradle.docker.shaded.org.bouncycastle.asn1.ASN1BitString;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.asn1.ASN1EncodableVector;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.asn1.ASN1GeneralizedTime;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.asn1.ASN1Object;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.asn1.ASN1Primitive;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.asn1.ASN1Sequence;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.asn1.ASN1TaggedObject;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.asn1.DERSequence;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.asn1.x500.X500Name;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.asn1.x509.GeneralName;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.asn1.x509.ReasonFlags;

public class GetCRL
extends ASN1Object {
    private final X500Name issuerName;
    private GeneralName cRLName;
    private ASN1GeneralizedTime time;
    private ReasonFlags reasons;

    public GetCRL(X500Name x500Name, GeneralName generalName, ASN1GeneralizedTime aSN1GeneralizedTime, ReasonFlags reasonFlags) {
        this.issuerName = x500Name;
        this.cRLName = generalName;
        this.time = aSN1GeneralizedTime;
        this.reasons = reasonFlags;
    }

    private GetCRL(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() < 1 || aSN1Sequence.size() > 4) {
            throw new IllegalArgumentException("incorrect sequence size");
        }
        this.issuerName = X500Name.getInstance(aSN1Sequence.getObjectAt(0));
        int n = 1;
        if (aSN1Sequence.size() > n && aSN1Sequence.getObjectAt(n).toASN1Primitive() instanceof ASN1TaggedObject) {
            this.cRLName = GeneralName.getInstance(aSN1Sequence.getObjectAt(n++));
        }
        if (aSN1Sequence.size() > n && aSN1Sequence.getObjectAt(n).toASN1Primitive() instanceof ASN1GeneralizedTime) {
            this.time = ASN1GeneralizedTime.getInstance(aSN1Sequence.getObjectAt(n++));
        }
        if (aSN1Sequence.size() > n && aSN1Sequence.getObjectAt(n).toASN1Primitive() instanceof ASN1BitString) {
            this.reasons = new ReasonFlags(ASN1BitString.getInstance(aSN1Sequence.getObjectAt(n)));
        }
    }

    public static GetCRL getInstance(Object object) {
        if (object instanceof GetCRL) {
            return (GetCRL)object;
        }
        if (object != null) {
            return new GetCRL(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public X500Name getIssuerName() {
        return this.issuerName;
    }

    public GeneralName getcRLName() {
        return this.cRLName;
    }

    public ASN1GeneralizedTime getTime() {
        return this.time;
    }

    public ReasonFlags getReasons() {
        return this.reasons;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector(4);
        aSN1EncodableVector.add(this.issuerName);
        if (this.cRLName != null) {
            aSN1EncodableVector.add(this.cRLName);
        }
        if (this.time != null) {
            aSN1EncodableVector.add(this.time);
        }
        if (this.reasons != null) {
            aSN1EncodableVector.add(this.reasons);
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

