/*
 * Decompiled with CFR 0.152.
 */
package com.bmuschko.gradle.clover;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.gradle.api.InvalidUserDataException;

@JsonDeserialize(builder=Builder.class)
public class CloverReportColumn
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String column;
    private final Map<String, String> attributes;
    private static final Pattern scopeValidator = Pattern.compile("(package|class|method)");
    private static final Map<String, FormatValidator> validColumns;

    public CloverReportColumn(String column, Map<String, String> attributes) {
        if (!CloverReportColumn.validColumn(column)) {
            throw new InvalidUserDataException("Column '" + column + "' is not supported");
        }
        this.column = column;
        this.attributes = new TreeMap<String, String>();
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            String key = entry.getKey();
            if (key.equals("format")) {
                this.assertValidFormat(column, entry.getValue());
            } else if (key.equals("min") || key.equals("max")) {
                this.assertValidNumber(column, entry.getValue());
            } else if (key.equals("scope")) {
                this.assertValidScope(column, entry.getValue());
            } else {
                String msg = String.format("Invalid column attribute '%s' for column %s", key, column);
                throw new InvalidUserDataException(msg);
            }
            this.attributes.put(key, entry.getValue());
        }
    }

    public String getColumn() {
        return this.column;
    }

    public Map<String, String> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    public String toJson() throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        return mapper.writeValueAsString((Object)this);
    }

    public static CloverReportColumn fromJson(String jsonString) throws JsonParseException, JsonMappingException, IOException {
        ObjectMapper mapper = new ObjectMapper();
        return (CloverReportColumn)mapper.readValue(jsonString, CloverReportColumn.class);
    }

    private void assertValidFormat(String name, String format) {
        FormatValidator validator = validColumns.get(name);
        if (!validator.valid(format)) {
            String msg = String.format("Invalid column format specification '%s' for column %s", format, name);
            throw new InvalidUserDataException(msg);
        }
    }

    private void assertValidNumber(String name, String value) {
        try {
            Integer.parseInt(value, 10);
        }
        catch (NumberFormatException e) {
            String msg = String.format("Invalid column min/max specification '%s' for column %s", value, name);
            throw new InvalidUserDataException(msg, (Throwable)e);
        }
    }

    private void assertValidScope(String name, String scope) {
        if (!scopeValidator.matcher(scope).matches()) {
            String msg = String.format("Invalid column scope specification '%s' for column %s", scope, name);
            throw new InvalidUserDataException(msg);
        }
    }

    public static boolean validColumn(String column) {
        return validColumns.containsKey(column);
    }

    static {
        RawFormatValidator raw = new RawFormatValidator();
        MultiFormatValidator multi = new MultiFormatValidator();
        validColumns = new HashMap<String, FormatValidator>();
        validColumns.put("avgClassesPerFile", raw);
        validColumns.put("avgMethodComplexity", raw);
        validColumns.put("avgMethodsPerClass", raw);
        validColumns.put("avgStatementsPerMethod", raw);
        validColumns.put("complexity", raw);
        validColumns.put("complexityDensity", raw);
        validColumns.put("coveredBranches", multi);
        validColumns.put("coveredElements", multi);
        validColumns.put("coveredMethods", multi);
        validColumns.put("coveredStatements", multi);
        validColumns.put("filteredElements", multi);
        validColumns.put("ncLineCount", raw);
        validColumns.put("lineCount", raw);
        validColumns.put("SUM", raw);
        validColumns.put("percentageCoveredContribution", multi);
        validColumns.put("percentageUncoveredContribution", multi);
        validColumns.put("totalBranches", raw);
        validColumns.put("totalChildren", raw);
        validColumns.put("totalClasses", raw);
        validColumns.put("totalElements", raw);
        validColumns.put("totalFiles", raw);
        validColumns.put("totalMethods", raw);
        validColumns.put("totalPercentageCovered", multi);
        validColumns.put("totalStatements", raw);
        validColumns.put("uncoveredBranches", multi);
        validColumns.put("uncoveredElements", multi);
        validColumns.put("uncoveredMethods", multi);
        validColumns.put("uncoveredStatements", multi);
        validColumns.put("files", raw);
        validColumns.put("methods", raw);
    }

    private static class MultiFormatValidator
    implements FormatValidator {
        private static final Pattern formatValidator = Pattern.compile("(raw|bar|longbar|%)");

        private MultiFormatValidator() {
        }

        @Override
        public boolean valid(String format) {
            return formatValidator.matcher(format).matches();
        }
    }

    private static class RawFormatValidator
    implements FormatValidator {
        private RawFormatValidator() {
        }

        @Override
        public boolean valid(String format) {
            return "raw".equals(format);
        }
    }

    private static interface FormatValidator {
        public boolean valid(String var1);
    }

    @JsonPOJOBuilder
    static class Builder {
        private String column;
        private Map<String, String> attributes;

        Builder() {
        }

        Builder withColumn(String column) {
            this.column = column;
            return this;
        }

        Builder withAttributes(Map<String, String> attributes) {
            this.attributes = attributes;
            return this;
        }

        public CloverReportColumn build() {
            return new CloverReportColumn(this.column, this.attributes);
        }
    }
}

