/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.loganalytics.models;

import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.loganalytics.fluent.models.TableInner;
import com.azure.resourcemanager.loganalytics.models.ProvisioningStateEnum;
import com.azure.resourcemanager.loganalytics.models.RestoredLogs;
import com.azure.resourcemanager.loganalytics.models.ResultStatistics;
import com.azure.resourcemanager.loganalytics.models.Schema;
import com.azure.resourcemanager.loganalytics.models.SearchResults;
import com.azure.resourcemanager.loganalytics.models.SystemDataAutoGenerated;
import com.azure.resourcemanager.loganalytics.models.TablePlanEnum;

public interface Table {
    public String id();

    public String name();

    public String type();

    public SystemDataAutoGenerated systemData();

    public Integer retentionInDays();

    public Integer totalRetentionInDays();

    public Integer archiveRetentionInDays();

    public SearchResults searchResults();

    public RestoredLogs restoredLogs();

    public ResultStatistics resultStatistics();

    public TablePlanEnum plan();

    public String lastPlanModifiedDate();

    public Schema schema();

    public ProvisioningStateEnum provisioningState();

    public String resourceGroupName();

    public TableInner innerModel();

    public Update update();

    public Table refresh();

    public Table refresh(Context var1);

    public void migrate();

    public Response<Void> migrateWithResponse(Context var1);

    public static interface UpdateStages {

        public static interface WithSchema {
            public Update withSchema(Schema var1);
        }

        public static interface WithPlan {
            public Update withPlan(TablePlanEnum var1);
        }

        public static interface WithResultStatistics {
            public Update withResultStatistics(ResultStatistics var1);
        }

        public static interface WithRestoredLogs {
            public Update withRestoredLogs(RestoredLogs var1);
        }

        public static interface WithSearchResults {
            public Update withSearchResults(SearchResults var1);
        }

        public static interface WithTotalRetentionInDays {
            public Update withTotalRetentionInDays(Integer var1);
        }

        public static interface WithRetentionInDays {
            public Update withRetentionInDays(Integer var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithRetentionInDays,
    UpdateStages.WithTotalRetentionInDays,
    UpdateStages.WithSearchResults,
    UpdateStages.WithRestoredLogs,
    UpdateStages.WithResultStatistics,
    UpdateStages.WithPlan,
    UpdateStages.WithSchema {
        public Table apply();

        public Table apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithSchema {
            public WithCreate withSchema(Schema var1);
        }

        public static interface WithPlan {
            public WithCreate withPlan(TablePlanEnum var1);
        }

        public static interface WithResultStatistics {
            public WithCreate withResultStatistics(ResultStatistics var1);
        }

        public static interface WithRestoredLogs {
            public WithCreate withRestoredLogs(RestoredLogs var1);
        }

        public static interface WithSearchResults {
            public WithCreate withSearchResults(SearchResults var1);
        }

        public static interface WithTotalRetentionInDays {
            public WithCreate withTotalRetentionInDays(Integer var1);
        }

        public static interface WithRetentionInDays {
            public WithCreate withRetentionInDays(Integer var1);
        }

        public static interface WithCreate
        extends WithRetentionInDays,
        WithTotalRetentionInDays,
        WithSearchResults,
        WithRestoredLogs,
        WithResultStatistics,
        WithPlan,
        WithSchema {
            public Table create();

            public Table create(Context var1);
        }

        public static interface WithParentResource {
            public WithCreate withExistingWorkspace(String var1, String var2);
        }

        public static interface Blank
        extends WithParentResource {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithParentResource,
    DefinitionStages.WithCreate {
    }
}

