/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.loganalytics.models;

import com.azure.core.util.Context;
import com.azure.resourcemanager.loganalytics.fluent.models.DataSourceInner;
import com.azure.resourcemanager.loganalytics.models.DataSourceKind;
import java.util.Map;

public interface DataSource {
    public String id();

    public String name();

    public String type();

    public Object properties();

    public String etag();

    public DataSourceKind kind();

    public Map<String, String> tags();

    public String resourceGroupName();

    public DataSourceInner innerModel();

    public Update update();

    public DataSource refresh();

    public DataSource refresh(Context var1);

    public static interface UpdateStages {

        public static interface WithKind {
            public Update withKind(DataSourceKind var1);
        }

        public static interface WithEtag {
            public Update withEtag(String var1);
        }

        public static interface WithProperties {
            public Update withProperties(Object var1);
        }

        public static interface WithTags {
            public Update withTags(Map<String, String> var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithTags,
    UpdateStages.WithProperties,
    UpdateStages.WithEtag,
    UpdateStages.WithKind {
        public DataSource apply();

        public DataSource apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithEtag {
            public WithCreate withEtag(String var1);
        }

        public static interface WithTags {
            public WithCreate withTags(Map<String, String> var1);
        }

        public static interface WithCreate
        extends WithTags,
        WithEtag {
            public DataSource create();

            public DataSource create(Context var1);
        }

        public static interface WithKind {
            public WithCreate withKind(DataSourceKind var1);
        }

        public static interface WithProperties {
            public WithKind withProperties(Object var1);
        }

        public static interface WithParentResource {
            public WithProperties withExistingWorkspace(String var1, String var2);
        }

        public static interface Blank
        extends WithParentResource {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithParentResource,
    DefinitionStages.WithProperties,
    DefinitionStages.WithKind,
    DefinitionStages.WithCreate {
    }
}

