/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.loganalytics.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.loganalytics.LogAnalyticsManager;
import com.azure.resourcemanager.loganalytics.fluent.QueriesClient;
import com.azure.resourcemanager.loganalytics.fluent.models.LogAnalyticsQueryPackQueryInner;
import com.azure.resourcemanager.loganalytics.implementation.LogAnalyticsQueryPackQueryImpl;
import com.azure.resourcemanager.loganalytics.implementation.Utils;
import com.azure.resourcemanager.loganalytics.models.LogAnalyticsQueryPackQuery;
import com.azure.resourcemanager.loganalytics.models.LogAnalyticsQueryPackQuerySearchProperties;
import com.azure.resourcemanager.loganalytics.models.Queries;

public final class QueriesImpl
implements Queries {
    private static final ClientLogger LOGGER = new ClientLogger(QueriesImpl.class);
    private final QueriesClient innerClient;
    private final LogAnalyticsManager serviceManager;

    public QueriesImpl(QueriesClient innerClient, LogAnalyticsManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<LogAnalyticsQueryPackQuery> list(String resourceGroupName, String queryPackName) {
        PagedIterable<LogAnalyticsQueryPackQueryInner> inner = this.serviceClient().list(resourceGroupName, queryPackName);
        return Utils.mapPage(inner, inner1 -> new LogAnalyticsQueryPackQueryImpl((LogAnalyticsQueryPackQueryInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<LogAnalyticsQueryPackQuery> list(String resourceGroupName, String queryPackName, Long top, Boolean includeBody, String skipToken, Context context) {
        PagedIterable<LogAnalyticsQueryPackQueryInner> inner = this.serviceClient().list(resourceGroupName, queryPackName, top, includeBody, skipToken, context);
        return Utils.mapPage(inner, inner1 -> new LogAnalyticsQueryPackQueryImpl((LogAnalyticsQueryPackQueryInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<LogAnalyticsQueryPackQuery> search(String resourceGroupName, String queryPackName, LogAnalyticsQueryPackQuerySearchProperties querySearchProperties) {
        PagedIterable<LogAnalyticsQueryPackQueryInner> inner = this.serviceClient().search(resourceGroupName, queryPackName, querySearchProperties);
        return Utils.mapPage(inner, inner1 -> new LogAnalyticsQueryPackQueryImpl((LogAnalyticsQueryPackQueryInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<LogAnalyticsQueryPackQuery> search(String resourceGroupName, String queryPackName, LogAnalyticsQueryPackQuerySearchProperties querySearchProperties, Long top, Boolean includeBody, String skipToken, Context context) {
        PagedIterable<LogAnalyticsQueryPackQueryInner> inner = this.serviceClient().search(resourceGroupName, queryPackName, querySearchProperties, top, includeBody, skipToken, context);
        return Utils.mapPage(inner, inner1 -> new LogAnalyticsQueryPackQueryImpl((LogAnalyticsQueryPackQueryInner)inner1, this.manager()));
    }

    @Override
    public LogAnalyticsQueryPackQuery get(String resourceGroupName, String queryPackName, String id) {
        LogAnalyticsQueryPackQueryInner inner = this.serviceClient().get(resourceGroupName, queryPackName, id);
        if (inner != null) {
            return new LogAnalyticsQueryPackQueryImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<LogAnalyticsQueryPackQuery> getWithResponse(String resourceGroupName, String queryPackName, String id, Context context) {
        Response<LogAnalyticsQueryPackQueryInner> inner = this.serviceClient().getWithResponse(resourceGroupName, queryPackName, id, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new LogAnalyticsQueryPackQueryImpl((LogAnalyticsQueryPackQueryInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public void delete(String resourceGroupName, String queryPackName, String id) {
        this.serviceClient().delete(resourceGroupName, queryPackName, id);
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String queryPackName, String id, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, queryPackName, id, context);
    }

    @Override
    public LogAnalyticsQueryPackQuery getById(String id) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String queryPackName = Utils.getValueFromIdByName(id, "queryPacks");
        if (queryPackName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'queryPacks'.", id)));
        }
        String varId = Utils.getValueFromIdByName(id, "queries");
        if (varId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'queries'.", id)));
        }
        return (LogAnalyticsQueryPackQuery)this.getWithResponse(resourceGroupName, queryPackName, varId, Context.NONE).getValue();
    }

    @Override
    public Response<LogAnalyticsQueryPackQuery> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String queryPackName = Utils.getValueFromIdByName(id, "queryPacks");
        if (queryPackName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'queryPacks'.", id)));
        }
        String varId = Utils.getValueFromIdByName(id, "queries");
        if (varId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'queries'.", id)));
        }
        return this.getWithResponse(resourceGroupName, queryPackName, varId, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String queryPackName = Utils.getValueFromIdByName(id, "queryPacks");
        if (queryPackName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'queryPacks'.", id)));
        }
        String varId = Utils.getValueFromIdByName(id, "queries");
        if (varId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'queries'.", id)));
        }
        this.deleteWithResponse(resourceGroupName, queryPackName, varId, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String queryPackName = Utils.getValueFromIdByName(id, "queryPacks");
        if (queryPackName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'queryPacks'.", id)));
        }
        String varId = Utils.getValueFromIdByName(id, "queries");
        if (varId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'queries'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, queryPackName, varId, context);
    }

    private QueriesClient serviceClient() {
        return this.innerClient;
    }

    private LogAnalyticsManager manager() {
        return this.serviceManager;
    }

    @Override
    public LogAnalyticsQueryPackQueryImpl define(String name) {
        return new LogAnalyticsQueryPackQueryImpl(name, this.manager());
    }
}

