/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.loganalytics.implementation;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.loganalytics.LogAnalyticsManager;
import com.azure.resourcemanager.loganalytics.fluent.models.LogAnalyticsQueryPackQueryInner;
import com.azure.resourcemanager.loganalytics.implementation.Utils;
import com.azure.resourcemanager.loganalytics.models.LogAnalyticsQueryPackQuery;
import com.azure.resourcemanager.loganalytics.models.LogAnalyticsQueryPackQueryPropertiesRelated;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class LogAnalyticsQueryPackQueryImpl
implements LogAnalyticsQueryPackQuery,
LogAnalyticsQueryPackQuery.Definition,
LogAnalyticsQueryPackQuery.Update {
    private LogAnalyticsQueryPackQueryInner innerObject;
    private final LogAnalyticsManager serviceManager;
    private String resourceGroupName;
    private String queryPackName;
    private String id;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public String idPropertiesId() {
        return this.innerModel().idPropertiesId();
    }

    @Override
    public String displayName() {
        return this.innerModel().displayName();
    }

    @Override
    public OffsetDateTime timeCreated() {
        return this.innerModel().timeCreated();
    }

    @Override
    public OffsetDateTime timeModified() {
        return this.innerModel().timeModified();
    }

    @Override
    public String author() {
        return this.innerModel().author();
    }

    @Override
    public String description() {
        return this.innerModel().description();
    }

    @Override
    public String body() {
        return this.innerModel().body();
    }

    @Override
    public LogAnalyticsQueryPackQueryPropertiesRelated related() {
        return this.innerModel().related();
    }

    @Override
    public Map<String, List<String>> tags() {
        Map<String, List<String>> inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public Object properties() {
        return this.innerModel().properties();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public LogAnalyticsQueryPackQueryInner innerModel() {
        return this.innerObject;
    }

    private LogAnalyticsManager manager() {
        return this.serviceManager;
    }

    @Override
    public LogAnalyticsQueryPackQueryImpl withExistingQueryPack(String resourceGroupName, String queryPackName) {
        this.resourceGroupName = resourceGroupName;
        this.queryPackName = queryPackName;
        return this;
    }

    @Override
    public LogAnalyticsQueryPackQuery create() {
        this.innerObject = (LogAnalyticsQueryPackQueryInner)this.serviceManager.serviceClient().getQueries().putWithResponse(this.resourceGroupName, this.queryPackName, this.id, this.innerModel(), Context.NONE).getValue();
        return this;
    }

    @Override
    public LogAnalyticsQueryPackQuery create(Context context) {
        this.innerObject = (LogAnalyticsQueryPackQueryInner)this.serviceManager.serviceClient().getQueries().putWithResponse(this.resourceGroupName, this.queryPackName, this.id, this.innerModel(), context).getValue();
        return this;
    }

    LogAnalyticsQueryPackQueryImpl(String name, LogAnalyticsManager serviceManager) {
        this.innerObject = new LogAnalyticsQueryPackQueryInner();
        this.serviceManager = serviceManager;
        this.id = name;
    }

    @Override
    public LogAnalyticsQueryPackQueryImpl update() {
        return this;
    }

    @Override
    public LogAnalyticsQueryPackQuery apply() {
        this.innerObject = (LogAnalyticsQueryPackQueryInner)this.serviceManager.serviceClient().getQueries().updateWithResponse(this.resourceGroupName, this.queryPackName, this.id, this.innerModel(), Context.NONE).getValue();
        return this;
    }

    @Override
    public LogAnalyticsQueryPackQuery apply(Context context) {
        this.innerObject = (LogAnalyticsQueryPackQueryInner)this.serviceManager.serviceClient().getQueries().updateWithResponse(this.resourceGroupName, this.queryPackName, this.id, this.innerModel(), context).getValue();
        return this;
    }

    LogAnalyticsQueryPackQueryImpl(LogAnalyticsQueryPackQueryInner innerObject, LogAnalyticsManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = Utils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.queryPackName = Utils.getValueFromIdByName(innerObject.id(), "queryPacks");
        this.id = Utils.getValueFromIdByName(innerObject.id(), "queries");
    }

    @Override
    public LogAnalyticsQueryPackQuery refresh() {
        this.innerObject = (LogAnalyticsQueryPackQueryInner)this.serviceManager.serviceClient().getQueries().getWithResponse(this.resourceGroupName, this.queryPackName, this.id, Context.NONE).getValue();
        return this;
    }

    @Override
    public LogAnalyticsQueryPackQuery refresh(Context context) {
        this.innerObject = (LogAnalyticsQueryPackQueryInner)this.serviceManager.serviceClient().getQueries().getWithResponse(this.resourceGroupName, this.queryPackName, this.id, context).getValue();
        return this;
    }

    @Override
    public LogAnalyticsQueryPackQueryImpl withTags(Map<String, List<String>> tags) {
        this.innerModel().withTags(tags);
        return this;
    }

    @Override
    public LogAnalyticsQueryPackQueryImpl withDisplayName(String displayName) {
        this.innerModel().withDisplayName(displayName);
        return this;
    }

    @Override
    public LogAnalyticsQueryPackQueryImpl withDescription(String description) {
        this.innerModel().withDescription(description);
        return this;
    }

    @Override
    public LogAnalyticsQueryPackQueryImpl withBody(String body) {
        this.innerModel().withBody(body);
        return this;
    }

    @Override
    public LogAnalyticsQueryPackQueryImpl withRelated(LogAnalyticsQueryPackQueryPropertiesRelated related) {
        this.innerModel().withRelated(related);
        return this;
    }

    @Override
    public LogAnalyticsQueryPackQueryImpl withProperties(Object properties) {
        this.innerModel().withProperties(properties);
        return this;
    }
}

