/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.loganalytics.fluent.models;

import com.azure.resourcemanager.loganalytics.models.PrivateLinkScopedResource;
import com.azure.resourcemanager.loganalytics.models.PublicNetworkAccessType;
import com.azure.resourcemanager.loganalytics.models.WorkspaceCapping;
import com.azure.resourcemanager.loganalytics.models.WorkspaceEntityStatus;
import com.azure.resourcemanager.loganalytics.models.WorkspaceFeatures;
import com.azure.resourcemanager.loganalytics.models.WorkspaceSku;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class WorkspaceProperties {
    @JsonProperty(value="provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private WorkspaceEntityStatus provisioningState;
    @JsonProperty(value="customerId", access=JsonProperty.Access.WRITE_ONLY)
    private String customerId;
    @JsonProperty(value="sku")
    private WorkspaceSku sku;
    @JsonProperty(value="retentionInDays")
    private Integer retentionInDays;
    @JsonProperty(value="workspaceCapping")
    private WorkspaceCapping workspaceCapping;
    @JsonProperty(value="createdDate", access=JsonProperty.Access.WRITE_ONLY)
    private String createdDate;
    @JsonProperty(value="modifiedDate", access=JsonProperty.Access.WRITE_ONLY)
    private String modifiedDate;
    @JsonProperty(value="publicNetworkAccessForIngestion")
    private PublicNetworkAccessType publicNetworkAccessForIngestion;
    @JsonProperty(value="publicNetworkAccessForQuery")
    private PublicNetworkAccessType publicNetworkAccessForQuery;
    @JsonProperty(value="forceCmkForQuery")
    private Boolean forceCmkForQuery;
    @JsonProperty(value="privateLinkScopedResources", access=JsonProperty.Access.WRITE_ONLY)
    private List<PrivateLinkScopedResource> privateLinkScopedResources;
    @JsonProperty(value="features")
    private WorkspaceFeatures features;
    @JsonProperty(value="defaultDataCollectionRuleResourceId")
    private String defaultDataCollectionRuleResourceId;

    public WorkspaceEntityStatus provisioningState() {
        return this.provisioningState;
    }

    public String customerId() {
        return this.customerId;
    }

    public WorkspaceSku sku() {
        return this.sku;
    }

    public WorkspaceProperties withSku(WorkspaceSku sku) {
        this.sku = sku;
        return this;
    }

    public Integer retentionInDays() {
        return this.retentionInDays;
    }

    public WorkspaceProperties withRetentionInDays(Integer retentionInDays) {
        this.retentionInDays = retentionInDays;
        return this;
    }

    public WorkspaceCapping workspaceCapping() {
        return this.workspaceCapping;
    }

    public WorkspaceProperties withWorkspaceCapping(WorkspaceCapping workspaceCapping) {
        this.workspaceCapping = workspaceCapping;
        return this;
    }

    public String createdDate() {
        return this.createdDate;
    }

    public String modifiedDate() {
        return this.modifiedDate;
    }

    public PublicNetworkAccessType publicNetworkAccessForIngestion() {
        return this.publicNetworkAccessForIngestion;
    }

    public WorkspaceProperties withPublicNetworkAccessForIngestion(PublicNetworkAccessType publicNetworkAccessForIngestion) {
        this.publicNetworkAccessForIngestion = publicNetworkAccessForIngestion;
        return this;
    }

    public PublicNetworkAccessType publicNetworkAccessForQuery() {
        return this.publicNetworkAccessForQuery;
    }

    public WorkspaceProperties withPublicNetworkAccessForQuery(PublicNetworkAccessType publicNetworkAccessForQuery) {
        this.publicNetworkAccessForQuery = publicNetworkAccessForQuery;
        return this;
    }

    public Boolean forceCmkForQuery() {
        return this.forceCmkForQuery;
    }

    public WorkspaceProperties withForceCmkForQuery(Boolean forceCmkForQuery) {
        this.forceCmkForQuery = forceCmkForQuery;
        return this;
    }

    public List<PrivateLinkScopedResource> privateLinkScopedResources() {
        return this.privateLinkScopedResources;
    }

    public WorkspaceFeatures features() {
        return this.features;
    }

    public WorkspaceProperties withFeatures(WorkspaceFeatures features) {
        this.features = features;
        return this;
    }

    public String defaultDataCollectionRuleResourceId() {
        return this.defaultDataCollectionRuleResourceId;
    }

    public WorkspaceProperties withDefaultDataCollectionRuleResourceId(String defaultDataCollectionRuleResourceId) {
        this.defaultDataCollectionRuleResourceId = defaultDataCollectionRuleResourceId;
        return this;
    }

    public void validate() {
        if (this.sku() != null) {
            this.sku().validate();
        }
        if (this.workspaceCapping() != null) {
            this.workspaceCapping().validate();
        }
        if (this.privateLinkScopedResources() != null) {
            this.privateLinkScopedResources().forEach(e -> e.validate());
        }
        if (this.features() != null) {
            this.features().validate();
        }
    }
}

