/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jms;

import com.atomikos.beans.PropertyUtils;
import com.atomikos.datasource.RecoverableResource;
import com.atomikos.datasource.pool.ConnectionPool;
import com.atomikos.datasource.pool.ConnectionPoolException;
import com.atomikos.datasource.pool.ConnectionPoolProperties;
import com.atomikos.datasource.pool.CreateConnectionException;
import com.atomikos.datasource.pool.PoolExhaustedException;
import com.atomikos.datasource.xa.jms.JmsTransactionalResource;
import com.atomikos.icatch.system.Configuration;
import com.atomikos.jms.AtomikosJMSException;
import com.atomikos.jms.AtomikosJmsXAConnectionFactory;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import com.atomikos.util.ClassLoadingHelper;
import com.atomikos.util.IntraVmObjectFactory;
import com.atomikos.util.IntraVmObjectRegistry;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.XAConnectionFactory;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;

public class AtomikosConnectionFactoryBean
implements ConnectionFactory,
ConnectionPoolProperties,
Referenceable,
Serializable {
    private static final Logger LOGGER = LoggerFactory.createLogger(AtomikosConnectionFactoryBean.class);
    private static final long serialVersionUID = 1L;
    private String uniqueResourceName;
    private int maxPoolSize = 1;
    private int minPoolSize = 1;
    private String xaConnectionFactoryClassName;
    private int borrowConnectionTimeout = 30;
    private Properties xaProperties = new Properties();
    private transient ConnectionPool connectionPool;
    private transient XAConnectionFactory xaConnectionFactory;
    private int maintenanceInterval = 60;
    private int maxIdleTime = 60;
    private int reapTimeout = 0;
    private boolean localTransactionMode;
    private int maxLifetime;
    private boolean ignoreSessionTransactedFlag = true;

    protected void throwAtomikosJMSException(String msg) throws AtomikosJMSException {
        this.throwAtomikosJMSException(msg, null);
    }

    protected void throwAtomikosJMSException(String msg, Throwable cause) throws AtomikosJMSException {
        AtomikosJMSException.throwAtomikosJMSException(msg, cause);
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public void setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    public int getMinPoolSize() {
        return this.minPoolSize;
    }

    public void setMinPoolSize(int minPoolSize) {
        this.minPoolSize = minPoolSize;
    }

    public void setPoolSize(int minAndMaxSize) {
        this.setMinPoolSize(minAndMaxSize);
        this.setMaxPoolSize(minAndMaxSize);
    }

    public String getUniqueResourceName() {
        return this.uniqueResourceName;
    }

    public void setUniqueResourceName(String resourceName) {
        this.uniqueResourceName = resourceName;
    }

    public String getXaConnectionFactoryClassName() {
        return this.xaConnectionFactoryClassName;
    }

    public void setXaConnectionFactoryClassName(String xaConnectionFactoryClassName) {
        this.xaConnectionFactoryClassName = xaConnectionFactoryClassName;
    }

    public Properties getXaProperties() {
        return this.xaProperties;
    }

    public void setXaProperties(Properties xaProperties) {
        this.xaProperties = xaProperties;
    }

    public XAConnectionFactory getXaConnectionFactory() {
        return this.xaConnectionFactory;
    }

    public void setXaConnectionFactory(XAConnectionFactory xaConnectionFactory) {
        this.xaConnectionFactory = xaConnectionFactory;
    }

    public void setMaxLifetime(int maxLifetime) {
        this.maxLifetime = maxLifetime;
    }

    public int getMaxLifetime() {
        return this.maxLifetime;
    }

    public synchronized void init() throws JMSException {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.logInfo(this + ": init...");
        }
        if (this.connectionPool != null) {
            return;
        }
        if (this.maxPoolSize < 1) {
            this.throwAtomikosJMSException("Property 'maxPoolSize' of class AtomikosConnectionFactoryBean must be greater than 0, was: " + this.maxPoolSize);
        }
        if (this.minPoolSize < 0 || this.minPoolSize > this.maxPoolSize) {
            this.throwAtomikosJMSException("Property 'minPoolSize' of class AtomikosConnectionFactoryBean must be at least 0 and at most maxPoolSize, was: " + this.minPoolSize);
        }
        if (this.getUniqueResourceName() == null) {
            this.throwAtomikosJMSException("Property 'uniqueResourceName' of class AtomikosConnectionFactoryBean cannot be null.");
        }
        try {
            this.getReference();
            com.atomikos.datasource.pool.ConnectionFactory cf = this.doInit();
            this.connectionPool = new ConnectionPool(cf, (ConnectionPoolProperties)this);
        }
        catch (AtomikosJMSException e) {
            throw e;
        }
        catch (Exception ex) {
            this.throwAtomikosJMSException("Cannot initialize AtomikosConnectionFactoryBean", ex);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.logDebug(this + ": init done.");
        }
    }

    protected String printXaProperties() {
        StringBuffer ret = new StringBuffer();
        if (this.xaProperties != null) {
            Enumeration<?> it = this.xaProperties.propertyNames();
            ret.append("[");
            boolean first = true;
            while (it.hasMoreElements()) {
                if (!first) {
                    ret.append(",");
                }
                String name = (String)it.nextElement();
                String value = this.xaProperties.getProperty(name);
                ret.append(name);
                ret.append("=");
                ret.append(value);
                first = false;
            }
            ret.append("]");
        }
        return ret.toString();
    }

    protected com.atomikos.datasource.pool.ConnectionFactory doInit() throws Exception {
        if (this.xaConnectionFactory == null) {
            if (this.xaConnectionFactoryClassName == null) {
                this.throwAtomikosJMSException("Property 'xaConnectionFactoryClassName' of class AtomikosConnectionFactoryBean cannot be null.");
            }
            if (this.xaProperties == null) {
                this.throwAtomikosJMSException("Property 'xaProperties' of class AtomikosConnectionFactoryBean cannot be null.");
            }
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.logInfo(this + ": initializing with [" + " xaConnectionFactory=" + this.xaConnectionFactory + "," + " xaConnectionFactoryClassName=" + this.xaConnectionFactoryClassName + "," + " uniqueResourceName=" + this.getUniqueResourceName() + "," + " maxPoolSize=" + this.getMaxPoolSize() + "," + " minPoolSize=" + this.getMinPoolSize() + "," + " borrowConnectionTimeout=" + this.getBorrowConnectionTimeout() + "," + " maxIdleTime=" + this.getMaxIdleTime() + "," + " reapTimeout=" + this.getReapTimeout() + "," + " maintenanceInterval=" + this.getMaintenanceInterval() + "," + " xaProperties=" + this.printXaProperties() + "," + " localTransactionMode=" + this.localTransactionMode + "," + " maxLifetime=" + this.maxLifetime + "," + " ignoreSessionTransactedFlag=" + this.ignoreSessionTransactedFlag + "]");
        }
        if (this.xaConnectionFactory == null) {
            Class xaClass = null;
            try {
                xaClass = ClassLoadingHelper.loadClass((String)this.xaConnectionFactoryClassName);
            }
            catch (ClassNotFoundException notFound) {
                AtomikosJMSException.throwAtomikosJMSException("The class '" + this.xaConnectionFactoryClassName + "' specified by property 'xaConnectionFactoryClassName' of class AtomikosConnectionFactoryBean could not be found in the classpath. " + "Please make sure the spelling in your setup is correct, and that the required jar(s) are in the classpath.", notFound);
            }
            Object driver = xaClass.newInstance();
            if (!(driver instanceof XAConnectionFactory)) {
                AtomikosJMSException.throwAtomikosJMSException("The class '" + this.xaConnectionFactoryClassName + "' specified by property 'xaConnectionFactoryClassName' of class AtomikosConnectionFactoryBean does not implement the required interface javax.jms.XAConnectionFactory. " + "Please make sure the spelling in your setup is correct, and check your JMS driver vendor's documentation.");
            }
            this.xaConnectionFactory = (XAConnectionFactory)driver;
            PropertyUtils.setProperties((Object)this.xaConnectionFactory, (Map)this.xaProperties);
        }
        JmsTransactionalResource tr = new JmsTransactionalResource(this.getUniqueResourceName(), this.xaConnectionFactory);
        AtomikosJmsXAConnectionFactory cf = new AtomikosJmsXAConnectionFactory(this.xaConnectionFactory, tr, this);
        Configuration.addResource((RecoverableResource)tr);
        return cf;
    }

    public int getBorrowConnectionTimeout() {
        return this.borrowConnectionTimeout;
    }

    public int getMaintenanceInterval() {
        return this.maintenanceInterval;
    }

    public int getMaxIdleTime() {
        return this.maxIdleTime;
    }

    public int getReapTimeout() {
        return this.reapTimeout;
    }

    public String getTestQuery() {
        return null;
    }

    public void setBorrowConnectionTimeout(int timeout) {
        this.borrowConnectionTimeout = timeout;
    }

    public void setMaintenanceInterval(int interval) {
        this.maintenanceInterval = interval;
    }

    public void setMaxIdleTime(int time) {
        this.maxIdleTime = time;
    }

    public void setReapTimeout(int timeout) {
        this.reapTimeout = timeout;
    }

    public boolean getLocalTransactionMode() {
        return this.localTransactionMode;
    }

    public void setLocalTransactionMode(boolean mode) {
        this.localTransactionMode = mode;
    }

    public int getDefaultIsolationLevel() {
        return -1;
    }

    public synchronized void close() {
        block6: {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.logInfo(this + ": close...");
            }
            if (this.connectionPool != null) {
                this.connectionPool.destroy();
                this.connectionPool = null;
            }
            try {
                IntraVmObjectRegistry.removeResource((String)this.getUniqueResourceName());
            }
            catch (NameNotFoundException e) {
                if (!LOGGER.isDebugEnabled()) break block6;
                LOGGER.logDebug(this + ": error removing from JNDI", (Throwable)e);
            }
        }
        RecoverableResource res = Configuration.getResource((String)this.getUniqueResourceName());
        if (res != null) {
            Configuration.removeResource((String)this.getUniqueResourceName());
            res.close();
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.logDebug(this + ": close done.");
        }
    }

    public String toString() {
        String ret = "AtomikosConnectionFactoryBean";
        String name = this.getUniqueResourceName();
        if (name != null) {
            ret = ret + " '" + name + "'";
        }
        return ret;
    }

    public Connection createConnection() throws JMSException {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.logInfo(this + ": createConnection()...");
        }
        Connection ret = null;
        try {
            this.init();
            ret = (Connection)this.connectionPool.borrowConnection(null);
        }
        catch (CreateConnectionException ex) {
            this.throwAtomikosJMSException("Failed to grow the connection pool", ex);
        }
        catch (PoolExhaustedException e) {
            this.throwAtomikosJMSException("Connection pool exhausted - try increasing 'maxPoolSize' and/or 'borrowConnectionTimeout' on the AtomikosConnectionFactoryBean.", e);
        }
        catch (ConnectionPoolException e) {
            this.throwAtomikosJMSException("Error borrowing connection", e);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.logDebug(this + ": createConnection() returning " + ret);
        }
        return ret;
    }

    public Connection createConnection(String user, String password) throws JMSException {
        LOGGER.logWarning(this + ": createConnection ( user , password ) ignores authentication - returning default connection");
        return this.createConnection();
    }

    @Override
    public Reference getReference() throws NamingException {
        Reference ret = null;
        if (LOGGER.isInfoEnabled()) {
            LOGGER.logInfo(this + ": getReference()...");
        }
        ret = IntraVmObjectFactory.createReference((Serializable)this, (String)this.getUniqueResourceName());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.logDebug(this + ": getReference() returning " + ret);
        }
        return ret;
    }

    public int poolAvailableSize() {
        return this.connectionPool.availableSize();
    }

    public int poolTotalSize() {
        return this.connectionPool.totalSize();
    }

    public void refreshPool() {
        if (this.connectionPool != null) {
            this.connectionPool.refresh();
        }
    }

    public boolean getIgnoreSessionTransactedFlag() {
        return this.ignoreSessionTransactedFlag;
    }

    public void setIgnoreSessionTransactedFlag(boolean value) {
        this.ignoreSessionTransactedFlag = value;
    }
}

