/*
 * Decompiled with CFR 0.152.
 */
package com.groupcdg.arcmutate.spring.mutators;

import com.groupcdg.arcmutate.spring.Group;
import com.groupcdg.arcmutate.spring.MutableAnnotation;
import com.groupcdg.arcmutate.spring.mutators.IdEncoder;
import com.groupcdg.arcmutate.spring.mutators.RemoveFieldAnnotationVisitor;
import com.groupcdg.arcmutate.spring.mutators.RemoveParameterAnnotationVisitor;
import java.util.Set;
import java.util.stream.Collectors;
import org.pitest.classinfo.ClassName;
import org.pitest.mutationtest.engine.Location;
import org.pitest.mutationtest.engine.MutationIdentifier;
import org.pitest.mutationtest.engine.gregor.AnnotationInfo;
import org.pitest.mutationtest.engine.gregor.FieldInfo;
import org.pitest.mutationtest.engine.gregor.MethodInfo;
import org.pitest.mutationtest.engine.gregor.MethodMutatorFactory;
import org.pitest.mutationtest.engine.gregor.MutationContext;
import org.pitest.mutationtest.engine.gregor.NoMethodContext;
import org.pitest.reloc.asm.FieldVisitor;
import org.pitest.reloc.asm.MethodVisitor;

public interface AnnotationMutator
extends MethodMutatorFactory {
    public boolean canMutate(ClassName var1);

    default public MethodVisitor create(MutationContext context, MethodInfo methodInfo, MethodVisitor methodVisitor) {
        ClassName owner = ClassName.fromString((String)context.getClassInfo().getName());
        Location loc = Location.location((ClassName)owner, (String)methodInfo.getName(), (String)methodInfo.getMethodDescriptor());
        return new RemoveParameterAnnotationVisitor(this, loc, context, methodVisitor);
    }

    default public boolean skipAnnotation(NoMethodContext context, AnnotationInfo annotationInfo) {
        ClassName annotationType = AnnotationMutator.parseType(annotationInfo.descriptor());
        if (this.canMutate(annotationType)) {
            MutationIdentifier newId = this.idEncoder().encodeForClass(ClassName.fromString((String)context.getClassInfo().getName()), annotationType);
            context.registerMutation(newId, "Removed annotation " + this.describeAnnotation(annotationInfo.descriptor()) + " from class");
            if (context.shouldMutate(newId)) {
                return true;
            }
        }
        return false;
    }

    default public FieldVisitor createForField(NoMethodContext context, FieldInfo fieldInfo, FieldVisitor fieldVisitor) {
        return new RemoveFieldAnnotationVisitor(this, context, fieldInfo, fieldVisitor);
    }

    default public String getGloballyUniqueId() {
        return this.getClass().getName();
    }

    default public boolean isMutatorFor(MutationIdentifier id) {
        return id.getMutator().startsWith(this.getGloballyUniqueId());
    }

    default public String describeAnnotation(String descriptor) {
        return descriptor.substring(1).replace(";", "").replace('/', '.');
    }

    default public IdEncoder idEncoder() {
        return new IdEncoder(this.getGloballyUniqueId());
    }

    public static Set<ClassName> supports(Group group) {
        return MutableAnnotation.forGroup(group).stream().map(a -> a.className()).collect(Collectors.toSet());
    }

    public static ClassName parseType(String descriptor) {
        return ClassName.fromString((String)descriptor.substring(1).substring(0, descriptor.length() - 2));
    }
}

