/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.validation;

import com.android.tools.build.bundletool.exceptions.ValidationException;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.BundleModuleName;
import com.android.tools.build.bundletool.model.ModuleEntry;
import com.android.tools.build.bundletool.utils.files.FilePreconditions;
import com.android.tools.build.bundletool.validation.BundleFilesValidator;
import com.android.tools.build.bundletool.validation.ModuleDependencyValidator;
import com.android.tools.build.bundletool.validation.ResourceTableValidator;
import com.android.tools.build.bundletool.validation.SubValidator;
import com.android.tools.build.bundletool.validation.ValidatorRunner;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.io.MoreFiles;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.function.Predicate;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class BundleModulesValidator {
    private static final ImmutableList<SubValidator> MODULES_SUB_VALIDATORS = ImmutableList.of((Object)new BundleFilesValidator(), (Object)new ModuleDependencyValidator(), (Object)new ResourceTableValidator());

    public void validate(ImmutableList<Path> modulePaths) {
        FilePreconditions.checkFileNamesAreUnique("Modules", modulePaths);
        ImmutableList modules = (ImmutableList)modulePaths.stream().map(this::toBundleModule).collect(ImmutableList.toImmutableList());
        new ValidatorRunner(MODULES_SUB_VALIDATORS).validate((ImmutableList<BundleModule>)modules);
    }

    private BundleModule toBundleModule(Path modulePath) {
        FilePreconditions.checkFileExistsAndReadable(modulePath);
        FilePreconditions.checkFileHasExtension("Module", modulePath, ".zip");
        BundleModuleName moduleName = BundleModuleName.create(MoreFiles.getNameWithoutExtension((Path)modulePath));
        try {
            ZipFile moduleZipFile = new ZipFile(modulePath.toFile());
            return BundleModule.builder().setName(moduleName).addEntries((Collection)moduleZipFile.stream().filter((Predicate<? extends ZipEntry>)Predicates.not(ZipEntry::isDirectory)).map(zipEntry -> ModuleEntry.fromModuleZipEntry(zipEntry, moduleZipFile)).collect(ImmutableList.toImmutableList())).build();
        }
        catch (IOException e) {
            throw new ValidationException(e, "Error reading module zip file '%s'.", modulePath);
        }
    }
}

