/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.utils.files;

import com.android.bundle.Files;
import com.android.bundle.Targeting;
import com.android.tools.build.bundletool.exceptions.ValidationException;
import com.android.tools.build.bundletool.utils.AbiUtils;
import com.android.tools.build.bundletool.utils.TargetingDimension;
import com.android.tools.build.bundletool.utils.files.DirectoryNameTokenizer;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class TargetingGenerator {
    private static final String ASSETS_DIR = "assets/";
    private static final String LIB_DIR = "lib/";
    private static final Pattern ASSETS_BASE_NAME_PATTERN = Pattern.compile("[a-zA-Z0-9][a-zA-Z0-9_]*");
    private static final Ordering<Targeting.TargetingQualifier> BY_DIMENSION_PRIORITY = TargetingDimension.PRIORITY_ORDERING.onResultOf(TargetingGenerator::toTargetingDimension);
    private final ImmutableMap<String, Targeting.TargetingQualifier> aliasToTargetingMap;

    public TargetingGenerator(Collection<Targeting.TargetingQualifier> aliasQualifiers) {
        this.aliasToTargetingMap = Maps.uniqueIndex(aliasQualifiers, q -> TargetingGenerator.treatCaseInsensitively("$" + q.getAlias()));
    }

    public Files.Assets generateTargetingForAssets(Collection<String> assetDirectories) {
        HashMap<String, Files.AssetsDirectoryGroup.Builder> directoryGroupsByName = new HashMap<String, Files.AssetsDirectoryGroup.Builder>();
        for (String directory : assetDirectories) {
            TargetingGenerator.checkRootDirectoryName(ASSETS_DIR, directory);
            String subDirectory = TargetingGenerator.treatCaseInsensitively(directory.substring(ASSETS_DIR.length()));
            ImmutableList<String> tokens = DirectoryNameTokenizer.forAssets().tokenize(subDirectory);
            String directoryGroupName = TargetingGenerator.checkAssetsDirectoryGroupName(TargetingGenerator.firstToken(tokens), directory);
            ImmutableList aliases = tokens.subList(1, tokens.size());
            ImmutableList<Targeting.TargetingQualifier> targetingQualifiers = this.resolveAliases((ImmutableList<String>)aliases, directory);
            Targeting.AssetsDirectoryTargeting.Builder directoryTargeting = Targeting.AssetsDirectoryTargeting.newBuilder();
            targetingQualifiers.forEach(qual -> TargetingGenerator.addToAssetsDirectoryTargeting(directoryTargeting, qual, directory));
            TargetingGenerator.getOrCreateDirectoryGroupByName(directoryGroupName, directoryGroupsByName).addTargetedDirectory(Files.TargetedAssetsDirectory.newBuilder().setPath(directory).setTargeting(directoryTargeting));
        }
        return Files.Assets.newBuilder().addAllDirectoryGroup((Iterable)directoryGroupsByName.values().stream().map(Files.AssetsDirectoryGroup.Builder::build).collect(ImmutableList.toImmutableList())).build();
    }

    public Files.NativeLibraries generateTargetingForNativeLibraries(Collection<String> libDirectories) {
        Files.NativeDirectoryGroup.Builder directoryGroup = Files.NativeDirectoryGroup.newBuilder();
        for (String directory : libDirectories) {
            TargetingGenerator.checkRootDirectoryName(LIB_DIR, directory);
            String subDirectory = TargetingGenerator.treatCaseInsensitively(directory.substring(LIB_DIR.length()));
            ImmutableList<String> tokens = DirectoryNameTokenizer.forNativeLibraries().tokenize(subDirectory);
            Targeting.Abi abi = TargetingGenerator.checkAbiName(TargetingGenerator.firstToken(tokens), directory);
            ImmutableList aliases = tokens.subList(1, tokens.size());
            ImmutableList<Targeting.TargetingQualifier> targetingQualifiers = this.resolveAliases((ImmutableList<String>)aliases, directory);
            Targeting.NativeDirectoryTargeting.Builder directoryTargeting = Targeting.NativeDirectoryTargeting.newBuilder();
            directoryTargeting.setAbi(abi);
            targetingQualifiers.forEach(qual -> TargetingGenerator.addToNativeDirectoryTargeting(directoryTargeting, qual, directory));
            directoryGroup.addTargetedDirectory(Files.TargetedNativeDirectory.newBuilder().setPath(directory).setTargeting(directoryTargeting));
        }
        return Files.NativeLibraries.newBuilder().addDirectoryGroup(directoryGroup).build();
    }

    private static String checkRootDirectoryName(String rootName, String forDirectory) {
        Preconditions.checkArgument((boolean)rootName.endsWith("/"), (String)"'%s' does not end with '/'.", (Object)rootName);
        Preconditions.checkArgument((boolean)forDirectory.startsWith(rootName), (String)"Directory '%s' must start with '%s'.", (Object)forDirectory, (Object)rootName);
        return rootName;
    }

    private static String checkAssetsDirectoryGroupName(String token, String forDirectory) {
        if (!ASSETS_BASE_NAME_PATTERN.matcher(token).matches()) {
            throw new ValidationException("Invalid %s directory group name '%s' in directory '%s'.", ASSETS_DIR, token, forDirectory);
        }
        return token;
    }

    private static Targeting.Abi checkAbiName(String token, String forDirectory) {
        Targeting.Abi.AbiAlias abiAlias = (Targeting.Abi.AbiAlias)((Object)AbiUtils.ABI_NAME_TO_PROTO_VALUE_MAP.get((Object)token));
        if (abiAlias == null) {
            throw new ValidationException("Expecting ABI name in directory '%s', found '%s'.", forDirectory, token);
        }
        return Targeting.Abi.newBuilder().setAlias(abiAlias).build();
    }

    private ImmutableList<Targeting.TargetingQualifier> resolveAliases(ImmutableList<String> aliases, String forDirectory) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (String alias : aliases) {
            Targeting.TargetingQualifier targetingQualifier = (Targeting.TargetingQualifier)this.aliasToTargetingMap.get((Object)alias);
            if (targetingQualifier == null) {
                throw new ValidationException("Unknown alias '%s' in directory '%s'.", alias, forDirectory);
            }
            result.add((Object)targetingQualifier);
        }
        return TargetingGenerator.checkDimensionOrderAndUniqueness((ImmutableList<Targeting.TargetingQualifier>)result.build(), forDirectory);
    }

    private static ImmutableList<Targeting.TargetingQualifier> checkDimensionOrderAndUniqueness(ImmutableList<Targeting.TargetingQualifier> qualifiers, String forDirectory) {
        if (!BY_DIMENSION_PRIORITY.isOrdered(qualifiers)) {
            throw new ValidationException("Targeting dimensions are not in correct order in directory '%s', expecting: %s", forDirectory, qualifiers.stream().sorted(BY_DIMENSION_PRIORITY).map(qual -> "$" + qual.getAlias()).collect(ImmutableList.toImmutableList()));
        }
        if (!BY_DIMENSION_PRIORITY.isStrictlyOrdered(qualifiers)) {
            throw new ValidationException("Found two aliases for the same dimension in directory '%s'.", forDirectory);
        }
        return qualifiers;
    }

    private static void addToAssetsDirectoryTargeting(Targeting.AssetsDirectoryTargeting.Builder targeting, Targeting.TargetingQualifier qual, String forDirectory) {
        switch (TargetingGenerator.toTargetingDimension(qual)) {
            case ABI: {
                targeting.setAbi(qual.getAbi());
                break;
            }
            case GRAPHICS_API: {
                targeting.setGraphicsApi(qual.getGraphicsApi());
                break;
            }
            case TEXTURE_COMPRESSION_FORMAT: {
                targeting.setTextureCompressionFormat(qual.getTextureCompressionFormat());
                break;
            }
            default: {
                throw new ValidationException("Alias '%s' for dimension %s is not supported in %s, but was found in directory '%s'.", new Object[]{qual.getAlias(), TargetingGenerator.toTargetingDimension(qual), ASSETS_DIR, forDirectory});
            }
        }
    }

    private static void addToNativeDirectoryTargeting(Targeting.NativeDirectoryTargeting.Builder targeting, Targeting.TargetingQualifier qual, String forDirectory) {
        switch (TargetingGenerator.toTargetingDimension(qual)) {
            case GRAPHICS_API: {
                targeting.setGraphicsApi(qual.getGraphicsApi());
                break;
            }
            case TEXTURE_COMPRESSION_FORMAT: {
                targeting.setTextureCompressionFormat(qual.getTextureCompressionFormat());
                break;
            }
            default: {
                throw new ValidationException("Alias '%s' for dimension %s is not supported in %s, but was found in directory '%s'.", new Object[]{qual.getAlias(), TargetingGenerator.toTargetingDimension(qual), LIB_DIR, forDirectory});
            }
        }
    }

    private static TargetingDimension toTargetingDimension(Targeting.TargetingQualifier qual) {
        if (qual.hasAbi()) {
            return TargetingDimension.ABI;
        }
        if (qual.hasGraphicsApi()) {
            return TargetingDimension.GRAPHICS_API;
        }
        if (qual.hasTextureCompressionFormat()) {
            return TargetingDimension.TEXTURE_COMPRESSION_FORMAT;
        }
        throw new IllegalArgumentException("TargetingQualifier of unknown dimension: " + qual);
    }

    private static String firstToken(ImmutableList<String> tokens) {
        Preconditions.checkArgument((!tokens.isEmpty() ? 1 : 0) != 0, (Object)"sub-directory cannot have empty name");
        return (String)tokens.get(0);
    }

    private static Files.AssetsDirectoryGroup.Builder getOrCreateDirectoryGroupByName(String name, Map<String, Files.AssetsDirectoryGroup.Builder> groupsByName) {
        if (!groupsByName.containsKey(name)) {
            groupsByName.put(name, Files.AssetsDirectoryGroup.newBuilder());
        }
        return groupsByName.get(name);
    }

    private static String treatCaseInsensitively(String s) {
        return s.toLowerCase();
    }
}

