/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.splitters;

import com.android.aapt.ConfigurationOuterClass;
import com.android.aapt.Resources;
import com.android.bundle.Targeting;
import com.android.tools.build.bundletool.model.ModuleEntry;
import com.android.tools.build.bundletool.model.ModuleSplit;
import com.android.tools.build.bundletool.model.PackageTypeEntry;
import com.android.tools.build.bundletool.splitters.ModuleSplitSplitter;
import com.android.tools.build.bundletool.splitters.ScreenDensityComparator;
import com.android.tools.build.bundletool.utils.ResourcesUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class ScreenDensityResourcesSplitter
implements ModuleSplitSplitter {
    static final ImmutableList<Targeting.ScreenDensity.DensityAlias> DEFAULT_DENSITY_SPLIT_CONFIG = ImmutableList.of((Object)((Object)Targeting.ScreenDensity.DensityAlias.LDPI), (Object)((Object)Targeting.ScreenDensity.DensityAlias.MDPI), (Object)((Object)Targeting.ScreenDensity.DensityAlias.HDPI), (Object)((Object)Targeting.ScreenDensity.DensityAlias.XHDPI), (Object)((Object)Targeting.ScreenDensity.DensityAlias.XXHDPI), (Object)((Object)Targeting.ScreenDensity.DensityAlias.XXXHDPI), (Object)((Object)Targeting.ScreenDensity.DensityAlias.TVDPI));

    @Override
    public ImmutableCollection<ModuleSplit> split(ModuleSplit split) {
        Optional<Resources.ResourceTable> resourceTable = split.getResourceTable();
        if (!resourceTable.isPresent()) {
            return ImmutableList.of((Object)split);
        }
        ImmutableList.Builder splitsBuilder = new ImmutableList.Builder();
        for (Targeting.ScreenDensity.DensityAlias density : DEFAULT_DENSITY_SPLIT_CONFIG) {
            Resources.ResourceTable optimizedTable = ScreenDensityResourcesSplitter.filterResourceTableForDensity(resourceTable.get(), density);
            ModuleSplit.Builder moduleSplitBuilder = split.toBuilder().setTargeting(split.getTargeting().toBuilder().setScreenDensity(Targeting.ScreenDensity.newBuilder().setDensityAlias(density)).build()).setEntries((List<ModuleEntry>)ModuleSplit.filterResourceEntries(split.getEntries(), optimizedTable)).setResourceTable(optimizedTable);
            splitsBuilder.add((Object)moduleSplitBuilder.build());
        }
        ModuleSplit defaultResourcesSplit = this.getDefaultResourcesSplit(split, (ImmutableCollection<ModuleSplit>)splitsBuilder.build());
        return splitsBuilder.add((Object)defaultResourcesSplit).build();
    }

    private ModuleSplit getDefaultResourcesSplit(ModuleSplit inputSplit, ImmutableCollection<ModuleSplit> densitySplits) {
        Resources.ResourceTable defaultSplitTable = this.getResourceTableForDefaultSplit(inputSplit, this.getClaimedConfigs((Iterable<ModuleSplit>)densitySplits));
        return inputSplit.toBuilder().setEntries((List<ModuleEntry>)ModuleSplit.filterResourceEntries(inputSplit.getEntries(), defaultSplitTable)).setResourceTable(defaultSplitTable).build();
    }

    private ImmutableMultimap<PackageTypeEntry, Resources.ConfigValue> getClaimedConfigs(Iterable<ModuleSplit> moduleSplits) {
        ImmutableMultimap.Builder result = new ImmutableMultimap.Builder();
        for (ModuleSplit moduleSplit : moduleSplits) {
            if (moduleSplit.getResourceTable().isPresent()) {
                // empty if block
            }
            for (Resources.Package pkg : moduleSplit.getResourceTable().get().getPackageList()) {
                for (Resources.Type type : pkg.getTypeList()) {
                    for (Resources.Entry entry : type.getEntryList()) {
                        for (Resources.ConfigValue configValue : entry.getConfigValueList()) {
                            result.put((Object)PackageTypeEntry.create((Resources.PackageOrBuilder)pkg, (Resources.TypeOrBuilder)type, (Resources.EntryOrBuilder)entry), (Object)configValue);
                        }
                    }
                }
            }
        }
        return result.build();
    }

    private Resources.ResourceTable getResourceTableForDefaultSplit(ModuleSplit split, ImmutableMultimap<PackageTypeEntry, Resources.ConfigValue> claimedConfigs) {
        Preconditions.checkArgument((boolean)split.getResourceTable().isPresent(), (Object)"Expected the split to contain Resource Table.");
        Resources.ResourceTable.Builder prunedTable = split.getResourceTable().get().toBuilder();
        for (Resources.Package.Builder packageBuilder : prunedTable.getPackageBuilderList()) {
            for (Resources.Type.Builder typeBuilder : packageBuilder.getTypeBuilderList()) {
                ArrayList<Resources.Entry> newEntries = new ArrayList<Resources.Entry>();
                for (Resources.Entry entry : typeBuilder.getEntryList()) {
                    ImmutableList allConfigsExceptClaimed = (ImmutableList)entry.getConfigValueList().stream().filter(configValue -> !claimedConfigs.containsEntry((Object)PackageTypeEntry.create((Resources.PackageOrBuilder)packageBuilder, (Resources.TypeOrBuilder)typeBuilder, (Resources.EntryOrBuilder)entry), configValue)).collect(ImmutableList.toImmutableList());
                    Resources.Entry.Builder newEntry = entry.toBuilder().clearConfigValue().addAllConfigValue((Iterable)allConfigsExceptClaimed);
                    if (newEntry.getConfigValueCount() <= 0) continue;
                    newEntries.add(newEntry.build());
                }
                typeBuilder.clearEntry().addAllEntry(newEntries);
            }
        }
        return prunedTable.build();
    }

    private static Resources.ResourceTable filterResourceTableForDensity(Resources.ResourceTable resourceTable, Targeting.ScreenDensity.DensityAlias density) {
        Resources.ResourceTable.Builder newTable = Resources.ResourceTable.newBuilder();
        for (Resources.Package pkg : resourceTable.getPackageList()) {
            Resources.Package.Builder newPackage = pkg.toBuilder().clearType();
            for (Resources.Type type : pkg.getTypeList()) {
                if (type.getName().equals("mipmap")) continue;
                Resources.Type.Builder newType = type.toBuilder().clearEntry();
                for (Resources.Entry entry : type.getEntryList()) {
                    Resources.Entry newEntry = ScreenDensityResourcesSplitter.filterEntryForDensity(entry, density);
                    if (newEntry.getConfigValueCount() <= 0) continue;
                    newType.addEntry(newEntry);
                }
                newPackage.addType(newType.build());
            }
            newTable.addPackage(newPackage.build());
        }
        return newTable.build();
    }

    private static Resources.Entry filterEntryForDensity(Resources.Entry initialEntry, Targeting.ScreenDensity.DensityAlias targetDensity) {
        Collection<List<Resources.ConfigValue>> densityGroups = initialEntry.getConfigValueList().stream().filter(configValue -> configValue.getConfig().getDensity() != 0).collect(Collectors.groupingBy(configValue -> ScreenDensityResourcesSplitter.clearDensity(configValue.getConfig()))).values();
        ImmutableList<Resources.ConfigValue> valuesToKeep = ScreenDensityResourcesSplitter.pickBestDensityForEachGroup(densityGroups, targetDensity);
        return initialEntry.toBuilder().clearConfigValue().addAllConfigValue(valuesToKeep).build();
    }

    private static ImmutableList<Resources.ConfigValue> pickBestDensityForEachGroup(Collection<List<Resources.ConfigValue>> densityGroups, Targeting.ScreenDensity.DensityAlias densityAlias) {
        ScreenDensityComparator screenDensityComparator = new ScreenDensityComparator((Integer)ResourcesUtils.DENSITY_ALIAS_TO_DPI_MAP.get((Object)densityAlias));
        return (ImmutableList)densityGroups.stream().map(group -> (Resources.ConfigValue)Collections.max(group, screenDensityComparator)).collect(ImmutableList.toImmutableList());
    }

    private static ConfigurationOuterClass.Configuration clearDensity(ConfigurationOuterClass.Configuration source) {
        return source.toBuilder().clearDensity().build();
    }
}

