/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.splitters;

import com.android.aapt.Resources;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.ModuleEntry;
import com.android.tools.build.bundletool.model.ModuleSplit;
import com.android.tools.build.bundletool.splitters.ModuleSplitSplitter;
import com.android.tools.build.bundletool.utils.ResourcesUtils;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class LanguageResourcesSplitter
implements ModuleSplitSplitter {
    @Override
    public ImmutableCollection<ModuleSplit> split(ModuleSplit split) {
        if (!split.getResourceTable().isPresent()) {
            return ImmutableList.of((Object)split);
        }
        Resources.ResourceTable resourceTable = split.getResourceTable().get();
        ImmutableMap<String, Resources.ResourceTable> byLanguage = LanguageResourcesSplitter.groupByLanguage(resourceTable);
        ImmutableList.Builder result = new ImmutableList.Builder();
        for (String language : byLanguage.keySet()) {
            ModuleSplit moduleSplit = split.toBuilder().setEntries((List<ModuleEntry>)LanguageResourcesSplitter.getEntriesForSplit(split.getEntries(), language, (Resources.ResourceTable)byLanguage.get((Object)language))).setResourceTable((Resources.ResourceTable)byLanguage.get((Object)language)).setTargeting(split.getTargeting().toBuilder().setLanguage(language).build()).build();
            result.add((Object)moduleSplit);
        }
        return result.build();
    }

    private static ImmutableList<ModuleEntry> getEntriesForSplit(ImmutableList<ModuleEntry> inputEntries, String language, Resources.ResourceTable resourceTable) {
        ImmutableList<ModuleEntry> entriesFromResourceTable = ModuleSplit.filterResourceEntries(inputEntries, resourceTable);
        if (language.isEmpty()) {
            ImmutableList.Builder result = new ImmutableList.Builder();
            result.addAll(entriesFromResourceTable);
            result.addAll((Iterable)inputEntries.stream().filter(entry -> !entry.getPath().startsWith(BundleModule.RESOURCES_DIRECTORY)).collect(ImmutableList.toImmutableList()));
            return result.build();
        }
        return entriesFromResourceTable;
    }

    private static ImmutableMap<String, Resources.ResourceTable> groupByLanguage(Resources.ResourceTable table) {
        Set languages = (Set)ResourcesUtils.configValues(table).map(configValue -> configValue.getConfig().getLocale()).map(LanguageResourcesSplitter::convertLocaleToLanguage).collect(ImmutableSet.toImmutableSet());
        ImmutableMap.Builder resourceTableByLanguage = new ImmutableMap.Builder();
        for (String language : languages) {
            resourceTableByLanguage.put((Object)language, (Object)LanguageResourcesSplitter.filterByLanguage(table, language));
        }
        if (!languages.contains("")) {
            resourceTableByLanguage.put((Object)"", (Object)Resources.ResourceTable.getDefaultInstance());
        }
        return resourceTableByLanguage.build();
    }

    private static Resources.ResourceTable filterByLanguage(Resources.ResourceTable input, String language) {
        Resources.ResourceTable.Builder resultTable = Resources.ResourceTable.newBuilder();
        for (Resources.Package pkg : input.getPackageList()) {
            Resources.Package.Builder newPkg = pkg.toBuilder().clearType();
            for (Resources.Type type : pkg.getTypeList()) {
                Resources.Type.Builder newType = type.toBuilder().clearEntry();
                for (Resources.Entry entry : type.getEntryList()) {
                    Resources.Entry.Builder newEntry = entry.toBuilder().clearConfigValue();
                    newEntry.addAllConfigValue(Iterables.filter((Iterable)entry.getConfigValueList(), configValue -> LanguageResourcesSplitter.convertLocaleToLanguage(configValue.getConfig().getLocale()).equals(language)));
                    if (newEntry.getConfigValueCount() <= 0) continue;
                    newType.addEntry(newEntry.build());
                }
                newPkg.addType(newType.build());
            }
            resultTable.addPackage(newPkg.build());
        }
        return resultTable.build();
    }

    private static String convertLocaleToLanguage(String locale) {
        int dashIndex = locale.indexOf(45);
        if (dashIndex == -1) {
            return locale;
        }
        return new Locale(locale.substring(0, dashIndex)).getLanguage();
    }
}

