/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.splitters;

import com.android.bundle.Files;
import com.android.bundle.Targeting;
import com.android.tools.build.bundletool.model.ModuleEntry;
import com.android.tools.build.bundletool.model.ModuleSplit;
import com.android.tools.build.bundletool.splitters.ModuleSplitSplitter;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Multimaps;
import com.google.protobuf.Message;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class AssetsDimensionSplitterFactory {
    public static <T extends Message> ModuleSplitSplitter createSplitter(final Function<Targeting.AssetsDirectoryTargeting, T> dimensionGetter, final Function<T, Targeting.SplitTargeting> targetingSetter, final Predicate<Targeting.SplitTargeting> hasTargeting) {
        return new ModuleSplitSplitter(){

            @Override
            public ImmutableCollection<ModuleSplit> split(ModuleSplit split) {
                Preconditions.checkArgument((!hasTargeting.test(split.getTargeting()) ? 1 : 0) != 0, (Object)"Split is already targeting the splitting dimension.");
                if (!split.getAssetsConfig().isPresent()) {
                    return ImmutableList.of((Object)split);
                }
                ImmutableList.Builder result = new ImmutableList.Builder();
                Files.Assets assetsConfig = split.getAssetsConfig().get();
                result.addAll((Iterable)assetsConfig.getDirectoryGroupList().stream().map(directoryGroup -> this.splitDirectoryGroup((Files.AssetsDirectoryGroup)directoryGroup, split)).flatMap(Collection::stream).collect(Collectors.toList()));
                ImmutableList<ModuleEntry> leftoverEntries = this.allUnclaimedEntries(assetsConfig, split);
                if (!leftoverEntries.isEmpty()) {
                    result.add((Object)split.toBuilder().setEntries((List<ModuleEntry>)leftoverEntries).build());
                }
                return result.build();
            }

            private ImmutableList<ModuleSplit> splitDirectoryGroup(Files.AssetsDirectoryGroup assetsDirectoryGroup, ModuleSplit split) {
                ImmutableListMultimap directoriesMap = Multimaps.index(assetsDirectoryGroup.getTargetedDirectoryList(), targetedDirectory -> (Message)dimensionGetter.apply((Object)targetedDirectory.getTargeting()));
                return (ImmutableList)directoriesMap.asMap().entrySet().stream().map(entry -> split.toBuilder().setEntries((List<ModuleEntry>)this.findEntriesInDirectories((Collection)entry.getValue(), split)).setTargeting(this.generateTargeting(split.getTargeting(), (Message)entry.getKey())).build()).filter(moduleSplit -> !moduleSplit.getEntries().isEmpty()).collect(ImmutableList.toImmutableList());
            }

            private Targeting.SplitTargeting generateTargeting(Targeting.SplitTargeting splitTargeting, T extraTargeting) {
                if (extraTargeting.equals((Object)extraTargeting.getDefaultInstanceForType())) {
                    return splitTargeting;
                }
                return splitTargeting.toBuilder().mergeFrom((Targeting.SplitTargeting)targetingSetter.apply(extraTargeting)).build();
            }

            private ImmutableList<ModuleEntry> allUnclaimedEntries(Files.Assets assetsConfig, ModuleSplit split) {
                HashSet<ModuleEntry> entries = new HashSet<ModuleEntry>((Collection<ModuleEntry>)split.getEntries());
                assetsConfig.getDirectoryGroupList().stream().map(Files.AssetsDirectoryGroup::getTargetedDirectoryList).flatMap(Collection::stream).forEach(directory -> split.findEntriesUnderModulePath(directory.getPath()).forEach(entries::remove));
                return ImmutableList.copyOf(entries);
            }

            private ImmutableList<ModuleEntry> findEntriesInDirectories(Collection<Files.TargetedAssetsDirectory> directories, ModuleSplit moduleSplit) {
                return (ImmutableList)directories.stream().flatMap(directory -> moduleSplit.findEntriesUnderModulePath(directory.getPath())).collect(ImmutableList.toImmutableList());
            }
        };
    }

    private AssetsDimensionSplitterFactory() {
    }
}

