/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.model;

import com.android.aapt.Resources;
import com.android.bundle.Files;
import com.android.bundle.Targeting;
import com.android.tools.build.bundletool.exceptions.CommandExecutionException;
import com.android.tools.build.bundletool.manifest.AndroidManifest;
import com.android.tools.build.bundletool.manifest.ManifestEditor;
import com.android.tools.build.bundletool.model.AutoValue_ModuleSplit;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.BundleModuleName;
import com.android.tools.build.bundletool.model.ModuleEntry;
import com.android.tools.build.bundletool.model.ModuleSplitOnDisk;
import com.android.tools.build.bundletool.utils.AbiUtils;
import com.android.tools.build.bundletool.utils.ResourcesUtils;
import com.android.tools.build.bundletool.utils.files.FilePreconditions;
import com.android.tools.build.bundletool.utils.zip.ZipBuilder;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.protobuf.MessageLite;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.stream.Stream;

@AutoValue
public abstract class ModuleSplit {
    private static final String MASTER_SPLIT_SUFFIX = "master";
    private static final ImmutableSet<Path> SPECIAL_ENTRIES = ImmutableSet.of((Object)BundleModule.MANIFEST_PATH, (Object)BundleModule.RESOURCES_PROTO_PATH);

    public abstract Targeting.SplitTargeting getTargeting();

    public abstract ImmutableList<ModuleEntry> getEntries();

    public abstract Optional<Resources.ResourceTable> getResourceTable();

    public abstract Optional<AndroidManifest> getAndroidManifest();

    public abstract BundleModuleName getModuleName();

    public abstract Optional<Files.NativeLibraries> getNativeConfig();

    public abstract Optional<Files.Assets> getAssetsConfig();

    public abstract Builder toBuilder();

    public String getSplitId() {
        StringBuilder splitIdBuilder = new StringBuilder(this.getSplitIdForMasterSplit());
        if (this.isMasterSplit()) {
            return splitIdBuilder.toString();
        }
        if (splitIdBuilder.length() > 0) {
            splitIdBuilder.append(".");
        }
        return splitIdBuilder.append("config.").append(this.getSuffix()).toString();
    }

    public String getSplitIdForMasterSplit() {
        return this.getModuleName().getNameForSplitId();
    }

    public ModuleSplitOnDisk writeTo(Path outputPath) {
        ZipBuilder zipBuilder = new ZipBuilder();
        for (ModuleEntry entry : this.getEntries()) {
            zipBuilder.addFileFromZip(ModuleSplit.toSplitEntryPath(entry.getPath()).toString(), entry.getZipFile(), entry.getZipEntry());
        }
        if (this.getResourceTable().isPresent()) {
            zipBuilder.addFileWithProtoContent(BundleModule.RESOURCES_PROTO_PATH.toString(), (MessageLite)this.getResourceTable().get());
        }
        if (this.getAndroidManifest().isPresent()) {
            ManifestEditor manifestEditor = this.getAndroidManifest().get().toEditor();
            if (this.isMasterSplit()) {
                manifestEditor.setSplitIdForFeatureSplit(this.getSplitId());
            } else {
                manifestEditor.setSplitIdForConfigSplit(this.getSplitId(), this.getSplitIdForMasterSplit());
            }
            AndroidManifest newManifest = manifestEditor.save();
            zipBuilder.addFileWithContent("AndroidManifest.xml", newManifest.getContent());
        }
        try {
            zipBuilder.writeTo(outputPath);
        }
        catch (IOException e) {
            throw new CommandExecutionException(e, "Error while generating the split '%s' for module: %s", this.getSuffix(), this.getModuleName());
        }
        return ModuleSplitOnDisk.builder().setModuleSplit(this).setPath(outputPath).build();
    }

    public boolean isMasterSplit() {
        return this.getTargeting().equals(Targeting.SplitTargeting.getDefaultInstance());
    }

    public static Path toSplitEntryPath(Path pathInModule) {
        if (pathInModule.startsWith(BundleModule.DEX_DIRECTORY)) {
            Preconditions.checkArgument((pathInModule.getNameCount() == 2 ? 1 : 0) != 0, (String)"Only files directly in the dex directory are supported but found: %s.", (Object)pathInModule);
            FilePreconditions.checkFileHasExtension("File under dex/ directory", pathInModule, ".dex");
            return pathInModule.getFileName();
        }
        if (pathInModule.startsWith(BundleModule.ROOT_DIRECTORY)) {
            Preconditions.checkArgument((pathInModule.getNameCount() >= 2 ? 1 : 0) != 0, (String)"Only files inside the root directory are supported but found: %s", (Object)pathInModule);
            return pathInModule.subpath(1, pathInModule.getNameCount());
        }
        return pathInModule;
    }

    public String getSuffix() {
        StringJoiner suffixJoiner = new StringJoiner("_");
        if (this.getTargeting().hasAbi()) {
            suffixJoiner.add(((String)AbiUtils.ABI_NAME_TO_PROTO_VALUE_MAP.inverse().get((Object)this.getTargeting().getAbi().getAlias())).replace('-', '_'));
        }
        if (!this.getTargeting().getLanguage().isEmpty()) {
            suffixJoiner.add(this.getTargeting().getLanguage());
        }
        if (this.getTargeting().hasScreenDensity()) {
            suffixJoiner.add(((String)ResourcesUtils.SCREEN_DENSITY_TO_PROTO_VALUE_MAP.inverse().get((Object)this.getTargeting().getScreenDensity().getDensityAlias())).replace('-', '_'));
        }
        if (this.getTargeting().hasGraphicsApi()) {
            suffixJoiner.add(ModuleSplit.formatGraphicsApi(this.getTargeting().getGraphicsApi()));
        }
        if (this.getTargeting().hasTextureCompressionFormat()) {
            suffixJoiner.add(this.getTargeting().getTextureCompressionFormat().getAlias().name().toLowerCase());
        }
        suffixJoiner.setEmptyValue(MASTER_SPLIT_SUFFIX);
        return suffixJoiner.toString();
    }

    private static String formatGraphicsApi(Targeting.GraphicsApi graphicsTargeting) {
        StringJoiner result = new StringJoiner("_");
        if (graphicsTargeting.hasOpenGlVersions()) {
            Targeting.OpenGlVersionRange range = graphicsTargeting.getOpenGlVersions();
            if (range.hasMin()) {
                result.add("glmin" + ModuleSplit.formatGlVersion(range.getMin()));
            }
            if (range.hasMax()) {
                result.add("glmax" + ModuleSplit.formatGlVersion(range.getMax()));
            }
        }
        return result.toString();
    }

    private static String formatGlVersion(Targeting.OpenGlVersion glVersion) {
        return glVersion.getMajor() + "_" + glVersion.getMinor();
    }

    public static ImmutableList<ModuleEntry> filterResourceEntries(ImmutableList<ModuleEntry> entries, Resources.ResourceTable resourceTable) {
        ImmutableSet<Path> referencedPaths = ResourcesUtils.getAllFileReferences(resourceTable);
        return (ImmutableList)entries.stream().filter(entry -> referencedPaths.contains((Object)entry.getPath())).collect(ImmutableList.toImmutableList());
    }

    public static Builder builder() {
        return new AutoValue_ModuleSplit.Builder();
    }

    public static ModuleSplit forModule(BundleModule bundleModule) {
        return ModuleSplit.fromBundleModule(bundleModule, (Predicate<ModuleEntry>)((Predicate)entry -> !SPECIAL_ENTRIES.contains((Object)entry.getPath())), true);
    }

    public static ModuleSplit forResources(BundleModule bundleModule) {
        return ModuleSplit.fromBundleModule(bundleModule, (Predicate<ModuleEntry>)((Predicate)entry -> entry.getPath().startsWith(BundleModule.RESOURCES_DIRECTORY)), true);
    }

    public static ModuleSplit forAssets(BundleModule bundleModule) {
        return ModuleSplit.fromBundleModule(bundleModule, (Predicate<ModuleEntry>)((Predicate)entry -> entry.getPath().startsWith(BundleModule.ASSETS_DIRECTORY)), false);
    }

    public static ModuleSplit forNativeLibraries(BundleModule bundleModule) {
        return ModuleSplit.fromBundleModule(bundleModule, (Predicate<ModuleEntry>)((Predicate)entry -> entry.getPath().startsWith(BundleModule.LIB_DIRECTORY)), false);
    }

    public static ModuleSplit forCode(BundleModule bundleModule) {
        return ModuleSplit.fromBundleModule(bundleModule, (Predicate<ModuleEntry>)((Predicate)entry -> entry.getPath().startsWith(BundleModule.DEX_DIRECTORY)), false);
    }

    public static ModuleSplit forRoot(BundleModule bundleModule) {
        return ModuleSplit.fromBundleModule(bundleModule, (Predicate<ModuleEntry>)((Predicate)entry -> entry.getPath().startsWith(BundleModule.ROOT_DIRECTORY)), false);
    }

    protected static ModuleSplit fromBundleModule(BundleModule bundleModule, Predicate<ModuleEntry> entriesPredicate, boolean setResourceTable) {
        Builder splitBuilder = ModuleSplit.builder().setModuleName(bundleModule.getName()).setEntries((List)bundleModule.getEntries().values().stream().filter(entriesPredicate).collect(ImmutableList.toImmutableList()));
        splitBuilder.setAndroidManifest(bundleModule.getManifest());
        bundleModule.getNativeConfig().ifPresent(splitBuilder::setNativeConfig);
        bundleModule.getAssetsConfig().ifPresent(splitBuilder::setAssetsConfig);
        if (setResourceTable) {
            bundleModule.getResourceTable().ifPresent(splitBuilder::setResourceTable);
        }
        return splitBuilder.setTargeting(Targeting.SplitTargeting.getDefaultInstance()).build();
    }

    public Stream<ModuleEntry> findEntriesUnderModulePath(String path) {
        return this.getEntries().stream().filter(entry -> entry.getPath().startsWith(path));
    }

    public static abstract class Builder {
        public abstract Builder setModuleName(BundleModuleName var1);

        public abstract Builder setNativeConfig(Files.NativeLibraries var1);

        public abstract Builder setAssetsConfig(Files.Assets var1);

        public abstract Builder setTargeting(Targeting.SplitTargeting var1);

        public abstract Builder setEntries(List<ModuleEntry> var1);

        protected abstract ImmutableList<ModuleEntry> getEntries();

        public abstract Builder setResourceTable(Resources.ResourceTable var1);

        public abstract Builder setAndroidManifest(AndroidManifest var1);

        protected abstract ModuleSplit autoBuild();

        public ModuleSplit build() {
            ModuleSplit moduleSplit = this.autoBuild();
            if (moduleSplit.getTargeting().hasAbi()) {
                Preconditions.checkState((moduleSplit.getTargeting().getLanguage().isEmpty() && !moduleSplit.getTargeting().hasScreenDensity() ? 1 : 0) != 0, (Object)"Splitting on ABI cannot be combined with any other dimension at the moment.");
            }
            Preconditions.checkState((this.getEntries().stream().filter(entry -> SPECIAL_ENTRIES.contains((Object)entry.getPath())).count() == 0L ? 1 : 0) != 0, (Object)"ModuleSplit entries cannot contain Resource Table or Android Manifest.");
            return moduleSplit;
        }
    }
}

