/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.model;

import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.BundleModuleName;
import com.android.tools.build.bundletool.model.ModuleEntry;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class AppBundle {
    private final ZipFile bundleFile;
    private final Map<BundleModuleName, BundleModule> modules;

    public AppBundle(ZipFile bundleFile) {
        this.bundleFile = bundleFile;
        this.modules = new HashMap<BundleModuleName, BundleModule>();
        this.open();
    }

    private void open() {
        HashMap<BundleModuleName, BundleModule.Builder> moduleBuilders = new HashMap<BundleModuleName, BundleModule.Builder>();
        Enumeration<? extends ZipEntry> entries = this.bundleFile.entries();
        while (entries.hasMoreElements()) {
            Path path;
            ZipEntry entry = entries.nextElement();
            if (entry.isDirectory() || (path = Paths.get(entry.getName(), new String[0])).startsWith("META-INF") || path.getNameCount() <= 1) continue;
            BundleModuleName moduleName = BundleModuleName.create(path.getName(0).toString());
            BundleModule.Builder moduleBuilder = moduleBuilders.computeIfAbsent(moduleName, name -> BundleModule.builder().setName((BundleModuleName)name));
            moduleBuilder.addEntry(ModuleEntry.fromBundleZipEntry(entry, this.bundleFile));
        }
        this.modules.putAll(Maps.transformValues(moduleBuilders, BundleModule.Builder::build));
    }

    public Map<BundleModuleName, BundleModule> getModules() {
        return ImmutableMap.copyOf(this.modules);
    }

    public Optional<BundleModule> getModule(BundleModuleName moduleName) {
        return Optional.ofNullable(this.modules.get(moduleName));
    }

    public ZipFile getBundleZipFile() {
        return this.bundleFile;
    }

    public String getBundlePath() {
        return this.bundleFile.getName();
    }
}

