/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool;

import com.android.tools.build.bundletool.AutoValue_BuildModuleCommand;
import com.android.tools.build.bundletool.utils.files.FilePreconditions;
import com.android.tools.build.bundletool.utils.flags.Flag;
import com.android.tools.build.bundletool.utils.flags.ParsedFlags;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import java.nio.file.Path;
import java.util.Optional;

@AutoValue
public abstract class BuildModuleCommand {
    public static final String COMMAND_NAME = "build-module";
    private static final Flag<Path> OUTPUT_FLAG = Flag.path("output");
    private static final Flag<Path> MANIFEST_FLAG = Flag.path("manifest");
    private static final Flag<Path> MANIFEST_DIR_FLAG = Flag.path("manifest-dir");
    private static final Flag<Path> DEX_FLAG = Flag.path("dex");
    private static final Flag<Path> DEX_DIR_FLAG = Flag.path("dex-dir");
    private static final Flag<Path> RESOURCES_DIR_FLAG = Flag.path("resources-dir");
    private static final Flag<Path> ASSETS_DIR_FLAG = Flag.path("assets-dir");
    private static final Flag<Path> NATIVE_DIR_FLAG = Flag.path("native-dir");

    public abstract Path getOutputPath();

    public abstract Optional<Path> getManifestPath();

    public abstract Optional<Path> getManifestDirPath();

    public abstract Optional<Path> getDexPath();

    public abstract Optional<Path> getDexDirPath();

    public abstract Optional<Path> getResourcesDirPath();

    public abstract Optional<Path> getAssetsDirPath();

    public abstract Optional<Path> getNativeDirPath();

    public static Builder builder() {
        return new AutoValue_BuildModuleCommand.Builder();
    }

    public static BuildModuleCommand fromFlags(ParsedFlags flags) {
        Builder builder = BuildModuleCommand.builder().setOutputPath(OUTPUT_FLAG.getRequiredValue(flags));
        MANIFEST_FLAG.value(flags).ifPresent(builder::setManifestPath);
        MANIFEST_DIR_FLAG.value(flags).ifPresent(builder::setManifestDirPath);
        DEX_FLAG.value(flags).ifPresent(builder::setDexPath);
        DEX_DIR_FLAG.value(flags).ifPresent(builder::setDexDirPath);
        RESOURCES_DIR_FLAG.value(flags).ifPresent(builder::setResourcesDirPath);
        ASSETS_DIR_FLAG.value(flags).ifPresent(builder::setAssetsDirPath);
        NATIVE_DIR_FLAG.value(flags).ifPresent(builder::setNativeDirPath);
        flags.checkNoUnknownFlags();
        return builder.build();
    }

    public void execute() {
        this.validateInput();
    }

    private void validateInput() {
        Preconditions.checkArgument((this.getManifestPath().isPresent() || this.getManifestDirPath().isPresent() ? 1 : 0) != 0, (String)"One of --%s or --%s is required.", MANIFEST_FLAG, MANIFEST_DIR_FLAG);
        Preconditions.checkArgument((!this.getManifestPath().isPresent() || !this.getManifestDirPath().isPresent() ? 1 : 0) != 0, (String)"Cannot set both --%s and --%s flags.", MANIFEST_FLAG, MANIFEST_DIR_FLAG);
        Preconditions.checkArgument((!this.getDexPath().isPresent() || !this.getDexDirPath().isPresent() ? 1 : 0) != 0, (String)"Cannot set both --%s and --%s flags.", DEX_FLAG, DEX_DIR_FLAG);
        FilePreconditions.checkFileDoesNotExist(this.getOutputPath());
        this.getManifestPath().ifPresent(FilePreconditions::checkFileExistsAndReadable);
        this.getManifestDirPath().ifPresent(FilePreconditions::checkDirectoryExists);
        this.getDexPath().ifPresent(FilePreconditions::checkFileExistsAndReadable);
        this.getDexDirPath().ifPresent(FilePreconditions::checkDirectoryExists);
        this.getResourcesDirPath().ifPresent(FilePreconditions::checkDirectoryExists);
        this.getAssetsDirPath().ifPresent(FilePreconditions::checkDirectoryExists);
        this.getNativeDirPath().ifPresent(FilePreconditions::checkDirectoryExists);
    }

    public static void help() {
        System.out.println(String.format("bundletool %s --output=<path/to/module.zip> [--%s=<path/to/AndroidManifest.flat>|--%s=<path/to/manifest-dir/>] [--%s=<path/to/classes.dex>|--%s=<path/to/dex-dir/>] [--%s=<path/to/res/>] [--%s=<path/to/assets/>] [--%s=<path/to/lib/>] ", COMMAND_NAME, MANIFEST_FLAG, MANIFEST_DIR_FLAG, DEX_FLAG, DEX_DIR_FLAG, RESOURCES_DIR_FLAG, ASSETS_DIR_FLAG, NATIVE_DIR_FLAG));
        System.out.println();
        System.out.println("Builds a module as a zip from an app's project. Note that the resources and the AndroidManifest.xml must already have been compiled with aapt2.");
        System.out.println();
        System.out.println("--output: Path to the zip file to build.");
        System.out.printf("--%s: Path to the AndroidManifest.flat compiled by aapt2. Use --%s if there are more than one.\n", MANIFEST_FLAG, MANIFEST_DIR_FLAG);
        System.out.printf("--%s: Path to the directory containing multiple Android manifests compiled by aapt2. A file named 'manifest-targeting.xml' must be present in the directory describing the targeting of each manifest present.\n", MANIFEST_DIR_FLAG);
        System.out.printf("--%s: Path to the dex file. Use --%s if there are more than one.\n", DEX_FLAG, DEX_DIR_FLAG);
        System.out.printf("--%s: Path to the directory containing multiple dex files. Unless all dex files must be included in the generated APKs (for MultiDex), a file named 'dex-targeting.xml' must be present in the directory describing the targeting of the different dex files.\n", DEX_DIR_FLAG);
        System.out.printf("--%s: Path to the directory containing the resources file(s). A file named 'resources.flat' must be present in that directory corresponding to the output of the aapt2 compilation of the resources.\n", RESOURCES_DIR_FLAG);
        System.out.printf("--%s: Path to the directory containing the assets.\n", ASSETS_DIR_FLAG);
        System.out.printf("--%s: Path to the directory containing the native libraries.\n", NATIVE_DIR_FLAG);
    }

    public static abstract class Builder {
        public abstract Builder setOutputPath(Path var1);

        public abstract Builder setManifestPath(Path var1);

        public abstract Builder setManifestDirPath(Path var1);

        public abstract Builder setDexPath(Path var1);

        public abstract Builder setDexDirPath(Path var1);

        public abstract Builder setResourcesDirPath(Path var1);

        public abstract Builder setAssetsDirPath(Path var1);

        public abstract Builder setNativeDirPath(Path var1);

        public abstract BuildModuleCommand build();
    }
}

