/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.runtime.api.client.runtimeapi;

import com.amazonaws.services.lambda.runtime.api.client.runtimeapi.dto.ErrorRequest;
import com.amazonaws.services.lambda.runtime.api.client.runtimeapi.dto.XRayErrorCause;
import com.amazonaws.services.lambda.runtime.serialization.PojoSerializer;
import com.amazonaws.services.lambda.runtime.serialization.factories.GsonFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class DtoSerializers {
    public static byte[] serialize(ErrorRequest error) {
        return DtoSerializers.serialize(error, SingletonHelper.LAMBDA_ERROR_SERIALIZER);
    }

    public static byte[] serialize(XRayErrorCause xRayErrorCause) {
        return DtoSerializers.serialize(xRayErrorCause, SingletonHelper.X_RAY_ERROR_CAUSE_SERIALIZER);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static <T> byte[] serialize(T pojo, PojoSerializer<T> serializer) {
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            serializer.toJson(pojo, (OutputStream)outputStream);
            byte[] byArray = outputStream.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            return null;
        }
    }

    private static class SingletonHelper {
        private static final PojoSerializer<ErrorRequest> LAMBDA_ERROR_SERIALIZER = GsonFactory.getInstance().getSerializer(ErrorRequest.class);
        private static final PojoSerializer<XRayErrorCause> X_RAY_ERROR_CAUSE_SERIALIZER = GsonFactory.getInstance().getSerializer(XRayErrorCause.class);

        private SingletonHelper() {
        }
    }
}

