/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.runtime.api.client;

import com.amazonaws.services.lambda.runtime.CustomPojoSerializer;
import com.amazonaws.services.lambda.runtime.api.client.AWSLambda;
import com.amazonaws.services.lambda.runtime.api.client.TooManyServiceProvidersFoundException;
import com.amazonaws.services.lambda.runtime.serialization.PojoSerializer;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;

public class PojoSerializerLoader {
    private static CustomPojoSerializer customPojoSerializer;
    private static boolean initialized;

    private static CustomPojoSerializer loadSerializer() throws ServiceConfigurationError, TooManyServiceProvidersFoundException {
        if (customPojoSerializer != null) {
            return customPojoSerializer;
        }
        ServiceLoader<CustomPojoSerializer> loader = ServiceLoader.load(CustomPojoSerializer.class, AWSLambda.customerClassLoader);
        Iterator<CustomPojoSerializer> serializers = loader.iterator();
        if (!serializers.hasNext()) {
            initialized = true;
            return null;
        }
        customPojoSerializer = serializers.next();
        if (serializers.hasNext()) {
            throw new TooManyServiceProvidersFoundException("Too many serializers provided inside the META-INF/services folder, only one is allowed");
        }
        initialized = true;
        return customPojoSerializer;
    }

    public static PojoSerializer<Object> getCustomerSerializer(final Type type) {
        if (!initialized) {
            customPojoSerializer = PojoSerializerLoader.loadSerializer();
        }
        if (customPojoSerializer == null) {
            return null;
        }
        return new PojoSerializer<Object>(){

            public Object fromJson(InputStream input) {
                return customPojoSerializer.fromJson(input, type);
            }

            public Object fromJson(String input) {
                return customPojoSerializer.fromJson(input, type);
            }

            public void toJson(Object value, OutputStream output) {
                customPojoSerializer.toJson(value, output, type);
            }
        };
    }

    static {
        initialized = false;
    }
}

