/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.runtime.events;

import java.util.List;
import java.util.Map;

public class S3BatchEventV2 {
    private String invocationSchemaVersion;
    private String invocationId;
    private Job job;
    private List<Task> tasks;

    public static S3BatchEventV2Builder builder() {
        return new S3BatchEventV2Builder();
    }

    public String getInvocationSchemaVersion() {
        return this.invocationSchemaVersion;
    }

    public String getInvocationId() {
        return this.invocationId;
    }

    public Job getJob() {
        return this.job;
    }

    public List<Task> getTasks() {
        return this.tasks;
    }

    public void setInvocationSchemaVersion(String invocationSchemaVersion) {
        this.invocationSchemaVersion = invocationSchemaVersion;
    }

    public void setInvocationId(String invocationId) {
        this.invocationId = invocationId;
    }

    public void setJob(Job job) {
        this.job = job;
    }

    public void setTasks(List<Task> tasks) {
        this.tasks = tasks;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof S3BatchEventV2)) {
            return false;
        }
        S3BatchEventV2 other = (S3BatchEventV2)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$invocationSchemaVersion = this.getInvocationSchemaVersion();
        String other$invocationSchemaVersion = other.getInvocationSchemaVersion();
        if (this$invocationSchemaVersion == null ? other$invocationSchemaVersion != null : !this$invocationSchemaVersion.equals(other$invocationSchemaVersion)) {
            return false;
        }
        String this$invocationId = this.getInvocationId();
        String other$invocationId = other.getInvocationId();
        if (this$invocationId == null ? other$invocationId != null : !this$invocationId.equals(other$invocationId)) {
            return false;
        }
        Job this$job = this.getJob();
        Job other$job = other.getJob();
        if (this$job == null ? other$job != null : !((Object)this$job).equals(other$job)) {
            return false;
        }
        List<Task> this$tasks = this.getTasks();
        List<Task> other$tasks = other.getTasks();
        return !(this$tasks == null ? other$tasks != null : !((Object)this$tasks).equals(other$tasks));
    }

    protected boolean canEqual(Object other) {
        return other instanceof S3BatchEventV2;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $invocationSchemaVersion = this.getInvocationSchemaVersion();
        result = result * 59 + ($invocationSchemaVersion == null ? 43 : $invocationSchemaVersion.hashCode());
        String $invocationId = this.getInvocationId();
        result = result * 59 + ($invocationId == null ? 43 : $invocationId.hashCode());
        Job $job = this.getJob();
        result = result * 59 + ($job == null ? 43 : ((Object)$job).hashCode());
        List<Task> $tasks = this.getTasks();
        result = result * 59 + ($tasks == null ? 43 : ((Object)$tasks).hashCode());
        return result;
    }

    public String toString() {
        return "S3BatchEventV2(invocationSchemaVersion=" + this.getInvocationSchemaVersion() + ", invocationId=" + this.getInvocationId() + ", job=" + this.getJob() + ", tasks=" + this.getTasks() + ")";
    }

    public S3BatchEventV2() {
    }

    public S3BatchEventV2(String invocationSchemaVersion, String invocationId, Job job, List<Task> tasks) {
        this.invocationSchemaVersion = invocationSchemaVersion;
        this.invocationId = invocationId;
        this.job = job;
        this.tasks = tasks;
    }

    public static class S3BatchEventV2Builder {
        private String invocationSchemaVersion;
        private String invocationId;
        private Job job;
        private List<Task> tasks;

        S3BatchEventV2Builder() {
        }

        public S3BatchEventV2Builder withInvocationSchemaVersion(String invocationSchemaVersion) {
            this.invocationSchemaVersion = invocationSchemaVersion;
            return this;
        }

        public S3BatchEventV2Builder withInvocationId(String invocationId) {
            this.invocationId = invocationId;
            return this;
        }

        public S3BatchEventV2Builder withJob(Job job) {
            this.job = job;
            return this;
        }

        public S3BatchEventV2Builder withTasks(List<Task> tasks) {
            this.tasks = tasks;
            return this;
        }

        public S3BatchEventV2 build() {
            return new S3BatchEventV2(this.invocationSchemaVersion, this.invocationId, this.job, this.tasks);
        }

        public String toString() {
            return "S3BatchEventV2.S3BatchEventV2Builder(invocationSchemaVersion=" + this.invocationSchemaVersion + ", invocationId=" + this.invocationId + ", job=" + this.job + ", tasks=" + this.tasks + ")";
        }
    }

    public static class Task {
        private String taskId;
        private String s3Key;
        private String s3VersionId;
        private String s3BucketName;

        public static TaskBuilder builder() {
            return new TaskBuilder();
        }

        public String getTaskId() {
            return this.taskId;
        }

        public String getS3Key() {
            return this.s3Key;
        }

        public String getS3VersionId() {
            return this.s3VersionId;
        }

        public String getS3BucketName() {
            return this.s3BucketName;
        }

        public void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        public void setS3Key(String s3Key) {
            this.s3Key = s3Key;
        }

        public void setS3VersionId(String s3VersionId) {
            this.s3VersionId = s3VersionId;
        }

        public void setS3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Task)) {
                return false;
            }
            Task other = (Task)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$taskId = this.getTaskId();
            String other$taskId = other.getTaskId();
            if (this$taskId == null ? other$taskId != null : !this$taskId.equals(other$taskId)) {
                return false;
            }
            String this$s3Key = this.getS3Key();
            String other$s3Key = other.getS3Key();
            if (this$s3Key == null ? other$s3Key != null : !this$s3Key.equals(other$s3Key)) {
                return false;
            }
            String this$s3VersionId = this.getS3VersionId();
            String other$s3VersionId = other.getS3VersionId();
            if (this$s3VersionId == null ? other$s3VersionId != null : !this$s3VersionId.equals(other$s3VersionId)) {
                return false;
            }
            String this$s3BucketName = this.getS3BucketName();
            String other$s3BucketName = other.getS3BucketName();
            return !(this$s3BucketName == null ? other$s3BucketName != null : !this$s3BucketName.equals(other$s3BucketName));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Task;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $taskId = this.getTaskId();
            result = result * 59 + ($taskId == null ? 43 : $taskId.hashCode());
            String $s3Key = this.getS3Key();
            result = result * 59 + ($s3Key == null ? 43 : $s3Key.hashCode());
            String $s3VersionId = this.getS3VersionId();
            result = result * 59 + ($s3VersionId == null ? 43 : $s3VersionId.hashCode());
            String $s3BucketName = this.getS3BucketName();
            result = result * 59 + ($s3BucketName == null ? 43 : $s3BucketName.hashCode());
            return result;
        }

        public String toString() {
            return "S3BatchEventV2.Task(taskId=" + this.getTaskId() + ", s3Key=" + this.getS3Key() + ", s3VersionId=" + this.getS3VersionId() + ", s3BucketName=" + this.getS3BucketName() + ")";
        }

        public Task() {
        }

        public Task(String taskId, String s3Key, String s3VersionId, String s3BucketName) {
            this.taskId = taskId;
            this.s3Key = s3Key;
            this.s3VersionId = s3VersionId;
            this.s3BucketName = s3BucketName;
        }

        public static class TaskBuilder {
            private String taskId;
            private String s3Key;
            private String s3VersionId;
            private String s3BucketName;

            TaskBuilder() {
            }

            public TaskBuilder withTaskId(String taskId) {
                this.taskId = taskId;
                return this;
            }

            public TaskBuilder withS3Key(String s3Key) {
                this.s3Key = s3Key;
                return this;
            }

            public TaskBuilder withS3VersionId(String s3VersionId) {
                this.s3VersionId = s3VersionId;
                return this;
            }

            public TaskBuilder withS3BucketName(String s3BucketName) {
                this.s3BucketName = s3BucketName;
                return this;
            }

            public Task build() {
                return new Task(this.taskId, this.s3Key, this.s3VersionId, this.s3BucketName);
            }

            public String toString() {
                return "S3BatchEventV2.Task.TaskBuilder(taskId=" + this.taskId + ", s3Key=" + this.s3Key + ", s3VersionId=" + this.s3VersionId + ", s3BucketName=" + this.s3BucketName + ")";
            }
        }
    }

    public static class Job {
        private String id;
        private Map<String, String> userArguments;

        public static JobBuilder builder() {
            return new JobBuilder();
        }

        public String getId() {
            return this.id;
        }

        public Map<String, String> getUserArguments() {
            return this.userArguments;
        }

        public void setId(String id) {
            this.id = id;
        }

        public void setUserArguments(Map<String, String> userArguments) {
            this.userArguments = userArguments;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Job)) {
                return false;
            }
            Job other = (Job)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            Map<String, String> this$userArguments = this.getUserArguments();
            Map<String, String> other$userArguments = other.getUserArguments();
            return !(this$userArguments == null ? other$userArguments != null : !((Object)this$userArguments).equals(other$userArguments));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Job;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            Map<String, String> $userArguments = this.getUserArguments();
            result = result * 59 + ($userArguments == null ? 43 : ((Object)$userArguments).hashCode());
            return result;
        }

        public String toString() {
            return "S3BatchEventV2.Job(id=" + this.getId() + ", userArguments=" + this.getUserArguments() + ")";
        }

        public Job() {
        }

        public Job(String id, Map<String, String> userArguments) {
            this.id = id;
            this.userArguments = userArguments;
        }

        public static class JobBuilder {
            private String id;
            private Map<String, String> userArguments;

            JobBuilder() {
            }

            public JobBuilder withId(String id) {
                this.id = id;
                return this;
            }

            public JobBuilder withUserArguments(Map<String, String> userArguments) {
                this.userArguments = userArguments;
                return this;
            }

            public Job build() {
                return new Job(this.id, this.userArguments);
            }

            public String toString() {
                return "S3BatchEventV2.Job.JobBuilder(id=" + this.id + ", userArguments=" + this.userArguments + ")";
            }
        }
    }
}

