/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.runtime.events.transformers.v2.dynamodb;

import com.amazonaws.services.lambda.runtime.events.models.dynamodb.AttributeValue;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.SdkBytes;

public class DynamodbAttributeValueTransformer {
    public static software.amazon.awssdk.services.dynamodb.model.AttributeValue toAttributeValueV2(AttributeValue value) {
        if (Objects.nonNull(value.getS())) {
            return (software.amazon.awssdk.services.dynamodb.model.AttributeValue)software.amazon.awssdk.services.dynamodb.model.AttributeValue.builder().s(value.getS()).build();
        }
        if (Objects.nonNull(value.getSS())) {
            return (software.amazon.awssdk.services.dynamodb.model.AttributeValue)software.amazon.awssdk.services.dynamodb.model.AttributeValue.builder().ss((Collection)(value.getSS().isEmpty() ? null : value.getSS())).build();
        }
        if (Objects.nonNull(value.getN())) {
            return (software.amazon.awssdk.services.dynamodb.model.AttributeValue)software.amazon.awssdk.services.dynamodb.model.AttributeValue.builder().n(value.getN()).build();
        }
        if (Objects.nonNull(value.getNS())) {
            return (software.amazon.awssdk.services.dynamodb.model.AttributeValue)software.amazon.awssdk.services.dynamodb.model.AttributeValue.builder().ns((Collection)(value.getNS().isEmpty() ? null : value.getNS())).build();
        }
        if (Objects.nonNull(value.getB())) {
            return (software.amazon.awssdk.services.dynamodb.model.AttributeValue)software.amazon.awssdk.services.dynamodb.model.AttributeValue.builder().b(SdkBytes.fromByteBuffer((ByteBuffer)value.getB())).build();
        }
        if (Objects.nonNull(value.getBS())) {
            return (software.amazon.awssdk.services.dynamodb.model.AttributeValue)software.amazon.awssdk.services.dynamodb.model.AttributeValue.builder().bs(value.getBS().isEmpty() ? null : (Collection)value.getBS().stream().map(SdkBytes::fromByteBuffer).collect(Collectors.toList())).build();
        }
        if (Objects.nonNull(value.getBOOL())) {
            return (software.amazon.awssdk.services.dynamodb.model.AttributeValue)software.amazon.awssdk.services.dynamodb.model.AttributeValue.builder().bool(value.getBOOL()).build();
        }
        if (Objects.nonNull(value.getL())) {
            return (software.amazon.awssdk.services.dynamodb.model.AttributeValue)software.amazon.awssdk.services.dynamodb.model.AttributeValue.builder().l(value.getL().isEmpty() ? Collections.emptyList() : (Collection)value.getL().stream().map(DynamodbAttributeValueTransformer::toAttributeValueV2).collect(Collectors.toList())).build();
        }
        if (Objects.nonNull(value.getM())) {
            return (software.amazon.awssdk.services.dynamodb.model.AttributeValue)software.amazon.awssdk.services.dynamodb.model.AttributeValue.builder().m(DynamodbAttributeValueTransformer.toAttributeValueMapV2(value.getM())).build();
        }
        if (Objects.nonNull(value.getNULL())) {
            return (software.amazon.awssdk.services.dynamodb.model.AttributeValue)software.amazon.awssdk.services.dynamodb.model.AttributeValue.builder().nul(value.getNULL()).build();
        }
        throw new IllegalArgumentException(String.format("Unsupported attributeValue type: %s", value));
    }

    public static Map<String, software.amazon.awssdk.services.dynamodb.model.AttributeValue> toAttributeValueMapV2(Map<String, AttributeValue> attributeValueMap) {
        return attributeValueMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> DynamodbAttributeValueTransformer.toAttributeValueV2((AttributeValue)entry.getValue())));
    }
}

