/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.translate;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.translate.AmazonTranslateAsync;
import com.amazonaws.services.translate.AmazonTranslateAsyncClientBuilder;
import com.amazonaws.services.translate.AmazonTranslateClient;
import com.amazonaws.services.translate.model.DeleteTerminologyRequest;
import com.amazonaws.services.translate.model.DeleteTerminologyResult;
import com.amazonaws.services.translate.model.GetTerminologyRequest;
import com.amazonaws.services.translate.model.GetTerminologyResult;
import com.amazonaws.services.translate.model.ImportTerminologyRequest;
import com.amazonaws.services.translate.model.ImportTerminologyResult;
import com.amazonaws.services.translate.model.ListTerminologiesRequest;
import com.amazonaws.services.translate.model.ListTerminologiesResult;
import com.amazonaws.services.translate.model.TranslateTextRequest;
import com.amazonaws.services.translate.model.TranslateTextResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonTranslateAsyncClient
extends AmazonTranslateClient
implements AmazonTranslateAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AmazonTranslateAsyncClientBuilder asyncBuilder() {
        return AmazonTranslateAsyncClientBuilder.standard();
    }

    AmazonTranslateAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super((AwsSyncClientParams)asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<DeleteTerminologyResult> deleteTerminologyAsync(DeleteTerminologyRequest request) {
        return this.deleteTerminologyAsync(request, null);
    }

    @Override
    public Future<DeleteTerminologyResult> deleteTerminologyAsync(DeleteTerminologyRequest request, final AsyncHandler<DeleteTerminologyRequest, DeleteTerminologyResult> asyncHandler) {
        final DeleteTerminologyRequest finalRequest = (DeleteTerminologyRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteTerminologyResult>(){

            @Override
            public DeleteTerminologyResult call() throws Exception {
                DeleteTerminologyResult result = null;
                try {
                    result = AmazonTranslateAsyncClient.this.executeDeleteTerminology(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetTerminologyResult> getTerminologyAsync(GetTerminologyRequest request) {
        return this.getTerminologyAsync(request, null);
    }

    @Override
    public Future<GetTerminologyResult> getTerminologyAsync(GetTerminologyRequest request, final AsyncHandler<GetTerminologyRequest, GetTerminologyResult> asyncHandler) {
        final GetTerminologyRequest finalRequest = (GetTerminologyRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetTerminologyResult>(){

            @Override
            public GetTerminologyResult call() throws Exception {
                GetTerminologyResult result = null;
                try {
                    result = AmazonTranslateAsyncClient.this.executeGetTerminology(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ImportTerminologyResult> importTerminologyAsync(ImportTerminologyRequest request) {
        return this.importTerminologyAsync(request, null);
    }

    @Override
    public Future<ImportTerminologyResult> importTerminologyAsync(ImportTerminologyRequest request, final AsyncHandler<ImportTerminologyRequest, ImportTerminologyResult> asyncHandler) {
        final ImportTerminologyRequest finalRequest = (ImportTerminologyRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ImportTerminologyResult>(){

            @Override
            public ImportTerminologyResult call() throws Exception {
                ImportTerminologyResult result = null;
                try {
                    result = AmazonTranslateAsyncClient.this.executeImportTerminology(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTerminologiesResult> listTerminologiesAsync(ListTerminologiesRequest request) {
        return this.listTerminologiesAsync(request, null);
    }

    @Override
    public Future<ListTerminologiesResult> listTerminologiesAsync(ListTerminologiesRequest request, final AsyncHandler<ListTerminologiesRequest, ListTerminologiesResult> asyncHandler) {
        final ListTerminologiesRequest finalRequest = (ListTerminologiesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTerminologiesResult>(){

            @Override
            public ListTerminologiesResult call() throws Exception {
                ListTerminologiesResult result = null;
                try {
                    result = AmazonTranslateAsyncClient.this.executeListTerminologies(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TranslateTextResult> translateTextAsync(TranslateTextRequest request) {
        return this.translateTextAsync(request, null);
    }

    @Override
    public Future<TranslateTextResult> translateTextAsync(TranslateTextRequest request, final AsyncHandler<TranslateTextRequest, TranslateTextResult> asyncHandler) {
        final TranslateTextRequest finalRequest = (TranslateTextRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TranslateTextResult>(){

            @Override
            public TranslateTextResult call() throws Exception {
                TranslateTextResult result = null;
                try {
                    result = AmazonTranslateAsyncClient.this.executeTranslateText(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

