/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.textract.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.textract.model.Block;
import com.amazonaws.services.textract.model.DocumentMetadata;
import com.amazonaws.services.textract.model.JobStatus;
import com.amazonaws.services.textract.model.Warning;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GetDocumentTextDetectionResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private DocumentMetadata documentMetadata;
    private String jobStatus;
    private String nextToken;
    private List<Block> blocks;
    private List<Warning> warnings;
    private String statusMessage;

    public void setDocumentMetadata(DocumentMetadata documentMetadata) {
        this.documentMetadata = documentMetadata;
    }

    public DocumentMetadata getDocumentMetadata() {
        return this.documentMetadata;
    }

    public GetDocumentTextDetectionResult withDocumentMetadata(DocumentMetadata documentMetadata) {
        this.setDocumentMetadata(documentMetadata);
        return this;
    }

    public void setJobStatus(String jobStatus) {
        this.jobStatus = jobStatus;
    }

    public String getJobStatus() {
        return this.jobStatus;
    }

    public GetDocumentTextDetectionResult withJobStatus(String jobStatus) {
        this.setJobStatus(jobStatus);
        return this;
    }

    public GetDocumentTextDetectionResult withJobStatus(JobStatus jobStatus) {
        this.jobStatus = jobStatus.toString();
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public GetDocumentTextDetectionResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public List<Block> getBlocks() {
        return this.blocks;
    }

    public void setBlocks(Collection<Block> blocks) {
        if (blocks == null) {
            this.blocks = null;
            return;
        }
        this.blocks = new ArrayList<Block>(blocks);
    }

    public GetDocumentTextDetectionResult withBlocks(Block ... blocks) {
        if (this.blocks == null) {
            this.setBlocks(new ArrayList<Block>(blocks.length));
        }
        for (Block ele : blocks) {
            this.blocks.add(ele);
        }
        return this;
    }

    public GetDocumentTextDetectionResult withBlocks(Collection<Block> blocks) {
        this.setBlocks(blocks);
        return this;
    }

    public List<Warning> getWarnings() {
        return this.warnings;
    }

    public void setWarnings(Collection<Warning> warnings) {
        if (warnings == null) {
            this.warnings = null;
            return;
        }
        this.warnings = new ArrayList<Warning>(warnings);
    }

    public GetDocumentTextDetectionResult withWarnings(Warning ... warnings) {
        if (this.warnings == null) {
            this.setWarnings(new ArrayList<Warning>(warnings.length));
        }
        for (Warning ele : warnings) {
            this.warnings.add(ele);
        }
        return this;
    }

    public GetDocumentTextDetectionResult withWarnings(Collection<Warning> warnings) {
        this.setWarnings(warnings);
        return this;
    }

    public void setStatusMessage(String statusMessage) {
        this.statusMessage = statusMessage;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public GetDocumentTextDetectionResult withStatusMessage(String statusMessage) {
        this.setStatusMessage(statusMessage);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDocumentMetadata() != null) {
            sb.append("DocumentMetadata: ").append(this.getDocumentMetadata()).append(",");
        }
        if (this.getJobStatus() != null) {
            sb.append("JobStatus: ").append(this.getJobStatus()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getBlocks() != null) {
            sb.append("Blocks: ").append(this.getBlocks()).append(",");
        }
        if (this.getWarnings() != null) {
            sb.append("Warnings: ").append(this.getWarnings()).append(",");
        }
        if (this.getStatusMessage() != null) {
            sb.append("StatusMessage: ").append(this.getStatusMessage());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDocumentTextDetectionResult)) {
            return false;
        }
        GetDocumentTextDetectionResult other = (GetDocumentTextDetectionResult)obj;
        if (other.getDocumentMetadata() == null ^ this.getDocumentMetadata() == null) {
            return false;
        }
        if (other.getDocumentMetadata() != null && !other.getDocumentMetadata().equals(this.getDocumentMetadata())) {
            return false;
        }
        if (other.getJobStatus() == null ^ this.getJobStatus() == null) {
            return false;
        }
        if (other.getJobStatus() != null && !other.getJobStatus().equals(this.getJobStatus())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getBlocks() == null ^ this.getBlocks() == null) {
            return false;
        }
        if (other.getBlocks() != null && !other.getBlocks().equals(this.getBlocks())) {
            return false;
        }
        if (other.getWarnings() == null ^ this.getWarnings() == null) {
            return false;
        }
        if (other.getWarnings() != null && !other.getWarnings().equals(this.getWarnings())) {
            return false;
        }
        if (other.getStatusMessage() == null ^ this.getStatusMessage() == null) {
            return false;
        }
        return other.getStatusMessage() == null || other.getStatusMessage().equals(this.getStatusMessage());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDocumentMetadata() == null ? 0 : this.getDocumentMetadata().hashCode());
        hashCode = 31 * hashCode + (this.getJobStatus() == null ? 0 : this.getJobStatus().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getBlocks() == null ? 0 : this.getBlocks().hashCode());
        hashCode = 31 * hashCode + (this.getWarnings() == null ? 0 : this.getWarnings().hashCode());
        hashCode = 31 * hashCode + (this.getStatusMessage() == null ? 0 : this.getStatusMessage().hashCode());
        return hashCode;
    }

    public GetDocumentTextDetectionResult clone() {
        try {
            return (GetDocumentTextDetectionResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

