/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.test.util.hamcrest;

import com.amazonaws.test.util.hamcrest.CollectionContainsOnly;
import com.amazonaws.test.util.hamcrest.CollectionContainsOnlyInOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;

public class Matchers {
    public static <T> Matcher<Collection<T>> containsOnlyInOrder(Matcher<? super T> ... matchers) {
        return CollectionContainsOnlyInOrder.containsOnlyInOrder(Arrays.asList(matchers));
    }

    public static <T> Matcher<Collection<T>> containsOnlyInOrder(T ... items) {
        return CollectionContainsOnlyInOrder.containsOnlyInOrder(Matchers.convertToMatchers(Arrays.asList(items)));
    }

    public static <T> Matcher<Collection<T>> containsOnly(Matcher<? super T> ... matchers) {
        return CollectionContainsOnly.containsOnly(Arrays.asList(matchers));
    }

    public static <T> Matcher<Collection<T>> containsOnly(T ... items) {
        return CollectionContainsOnly.containsOnly(Matchers.convertToMatchers(Arrays.asList(items)));
    }

    private static <T> List<Matcher<? super T>> convertToMatchers(List<T> items) {
        ArrayList<Matcher<T>> matchers = new ArrayList<Matcher<T>>();
        for (T item : items) {
            matchers.add(CoreMatchers.equalTo(item));
        }
        return matchers;
    }
}

