/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.taxsettings.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.taxsettings.model.AccountMetaData;
import java.util.Map;

@SdkInternalApi
public class AccountMetaDataMarshaller {
    private static final MarshallingInfo<String> ACCOUNTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("accountName").build();
    private static final MarshallingInfo<StructuredPojo> ADDRESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("address").build();
    private static final MarshallingInfo<Map> ADDRESSROLEMAP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("addressRoleMap").build();
    private static final MarshallingInfo<String> ADDRESSTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("addressType").build();
    private static final MarshallingInfo<String> SELLER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("seller").build();
    private static final AccountMetaDataMarshaller instance = new AccountMetaDataMarshaller();

    public static AccountMetaDataMarshaller getInstance() {
        return instance;
    }

    public void marshall(AccountMetaData accountMetaData, ProtocolMarshaller protocolMarshaller) {
        if (accountMetaData == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)accountMetaData.getAccountName(), ACCOUNTNAME_BINDING);
            protocolMarshaller.marshall((Object)accountMetaData.getAddress(), ADDRESS_BINDING);
            protocolMarshaller.marshall(accountMetaData.getAddressRoleMap(), ADDRESSROLEMAP_BINDING);
            protocolMarshaller.marshall((Object)accountMetaData.getAddressType(), ADDRESSTYPE_BINDING);
            protocolMarshaller.marshall((Object)accountMetaData.getSeller(), SELLER_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

