/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.sagemaker.model.S3DataDistribution;
import com.amazonaws.services.sagemaker.model.S3DataType;
import com.amazonaws.services.sagemaker.model.transform.S3DataSourceMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class S3DataSource
implements Serializable,
Cloneable,
StructuredPojo {
    private String s3DataType;
    private String s3Uri;
    private String s3DataDistributionType;
    private List<String> attributeNames;

    public void setS3DataType(String s3DataType) {
        this.s3DataType = s3DataType;
    }

    public String getS3DataType() {
        return this.s3DataType;
    }

    public S3DataSource withS3DataType(String s3DataType) {
        this.setS3DataType(s3DataType);
        return this;
    }

    public S3DataSource withS3DataType(S3DataType s3DataType) {
        this.s3DataType = s3DataType.toString();
        return this;
    }

    public void setS3Uri(String s3Uri) {
        this.s3Uri = s3Uri;
    }

    public String getS3Uri() {
        return this.s3Uri;
    }

    public S3DataSource withS3Uri(String s3Uri) {
        this.setS3Uri(s3Uri);
        return this;
    }

    public void setS3DataDistributionType(String s3DataDistributionType) {
        this.s3DataDistributionType = s3DataDistributionType;
    }

    public String getS3DataDistributionType() {
        return this.s3DataDistributionType;
    }

    public S3DataSource withS3DataDistributionType(String s3DataDistributionType) {
        this.setS3DataDistributionType(s3DataDistributionType);
        return this;
    }

    public S3DataSource withS3DataDistributionType(S3DataDistribution s3DataDistributionType) {
        this.s3DataDistributionType = s3DataDistributionType.toString();
        return this;
    }

    public List<String> getAttributeNames() {
        return this.attributeNames;
    }

    public void setAttributeNames(Collection<String> attributeNames) {
        if (attributeNames == null) {
            this.attributeNames = null;
            return;
        }
        this.attributeNames = new ArrayList<String>(attributeNames);
    }

    public S3DataSource withAttributeNames(String ... attributeNames) {
        if (this.attributeNames == null) {
            this.setAttributeNames(new ArrayList<String>(attributeNames.length));
        }
        for (String ele : attributeNames) {
            this.attributeNames.add(ele);
        }
        return this;
    }

    public S3DataSource withAttributeNames(Collection<String> attributeNames) {
        this.setAttributeNames(attributeNames);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getS3DataType() != null) {
            sb.append("S3DataType: ").append(this.getS3DataType()).append(",");
        }
        if (this.getS3Uri() != null) {
            sb.append("S3Uri: ").append(this.getS3Uri()).append(",");
        }
        if (this.getS3DataDistributionType() != null) {
            sb.append("S3DataDistributionType: ").append(this.getS3DataDistributionType()).append(",");
        }
        if (this.getAttributeNames() != null) {
            sb.append("AttributeNames: ").append(this.getAttributeNames());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3DataSource)) {
            return false;
        }
        S3DataSource other = (S3DataSource)obj;
        if (other.getS3DataType() == null ^ this.getS3DataType() == null) {
            return false;
        }
        if (other.getS3DataType() != null && !other.getS3DataType().equals(this.getS3DataType())) {
            return false;
        }
        if (other.getS3Uri() == null ^ this.getS3Uri() == null) {
            return false;
        }
        if (other.getS3Uri() != null && !other.getS3Uri().equals(this.getS3Uri())) {
            return false;
        }
        if (other.getS3DataDistributionType() == null ^ this.getS3DataDistributionType() == null) {
            return false;
        }
        if (other.getS3DataDistributionType() != null && !other.getS3DataDistributionType().equals(this.getS3DataDistributionType())) {
            return false;
        }
        if (other.getAttributeNames() == null ^ this.getAttributeNames() == null) {
            return false;
        }
        return other.getAttributeNames() == null || other.getAttributeNames().equals(this.getAttributeNames());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getS3DataType() == null ? 0 : this.getS3DataType().hashCode());
        hashCode = 31 * hashCode + (this.getS3Uri() == null ? 0 : this.getS3Uri().hashCode());
        hashCode = 31 * hashCode + (this.getS3DataDistributionType() == null ? 0 : this.getS3DataDistributionType().hashCode());
        hashCode = 31 * hashCode + (this.getAttributeNames() == null ? 0 : this.getAttributeNames().hashCode());
        return hashCode;
    }

    public S3DataSource clone() {
        try {
            return (S3DataSource)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        S3DataSourceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

