/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.route53profiles.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53profiles-2018-05-10/GetProfileAssociation"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class GetProfileAssociationResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable, Cloneable {

    /**
     * <p>
     * Information about the Profile association that you specified in a <code>GetProfileAssociation</code> request.
     * </p>
     */
    private ProfileAssociation profileAssociation;

    /**
     * <p>
     * Information about the Profile association that you specified in a <code>GetProfileAssociation</code> request.
     * </p>
     * 
     * @param profileAssociation
     *        Information about the Profile association that you specified in a <code>GetProfileAssociation</code>
     *        request.
     */

    public void setProfileAssociation(ProfileAssociation profileAssociation) {
        this.profileAssociation = profileAssociation;
    }

    /**
     * <p>
     * Information about the Profile association that you specified in a <code>GetProfileAssociation</code> request.
     * </p>
     * 
     * @return Information about the Profile association that you specified in a <code>GetProfileAssociation</code>
     *         request.
     */

    public ProfileAssociation getProfileAssociation() {
        return this.profileAssociation;
    }

    /**
     * <p>
     * Information about the Profile association that you specified in a <code>GetProfileAssociation</code> request.
     * </p>
     * 
     * @param profileAssociation
     *        Information about the Profile association that you specified in a <code>GetProfileAssociation</code>
     *        request.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetProfileAssociationResult withProfileAssociation(ProfileAssociation profileAssociation) {
        setProfileAssociation(profileAssociation);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getProfileAssociation() != null)
            sb.append("ProfileAssociation: ").append(getProfileAssociation());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof GetProfileAssociationResult == false)
            return false;
        GetProfileAssociationResult other = (GetProfileAssociationResult) obj;
        if (other.getProfileAssociation() == null ^ this.getProfileAssociation() == null)
            return false;
        if (other.getProfileAssociation() != null && other.getProfileAssociation().equals(this.getProfileAssociation()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getProfileAssociation() == null) ? 0 : getProfileAssociation().hashCode());
        return hashCode;
    }

    @Override
    public GetProfileAssociationResult clone() {
        try {
            return (GetProfileAssociationResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
