/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rekognition.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListCollectionsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<String> collectionIds;
    private String nextToken;
    private List<String> faceModelVersions;

    public List<String> getCollectionIds() {
        return this.collectionIds;
    }

    public void setCollectionIds(Collection<String> collectionIds) {
        if (collectionIds == null) {
            this.collectionIds = null;
            return;
        }
        this.collectionIds = new ArrayList<String>(collectionIds);
    }

    public ListCollectionsResult withCollectionIds(String ... collectionIds) {
        if (this.collectionIds == null) {
            this.setCollectionIds(new ArrayList<String>(collectionIds.length));
        }
        for (String ele : collectionIds) {
            this.collectionIds.add(ele);
        }
        return this;
    }

    public ListCollectionsResult withCollectionIds(Collection<String> collectionIds) {
        this.setCollectionIds(collectionIds);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListCollectionsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public List<String> getFaceModelVersions() {
        return this.faceModelVersions;
    }

    public void setFaceModelVersions(Collection<String> faceModelVersions) {
        if (faceModelVersions == null) {
            this.faceModelVersions = null;
            return;
        }
        this.faceModelVersions = new ArrayList<String>(faceModelVersions);
    }

    public ListCollectionsResult withFaceModelVersions(String ... faceModelVersions) {
        if (this.faceModelVersions == null) {
            this.setFaceModelVersions(new ArrayList<String>(faceModelVersions.length));
        }
        for (String ele : faceModelVersions) {
            this.faceModelVersions.add(ele);
        }
        return this;
    }

    public ListCollectionsResult withFaceModelVersions(Collection<String> faceModelVersions) {
        this.setFaceModelVersions(faceModelVersions);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCollectionIds() != null) {
            sb.append("CollectionIds: ").append(this.getCollectionIds()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getFaceModelVersions() != null) {
            sb.append("FaceModelVersions: ").append(this.getFaceModelVersions());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCollectionsResult)) {
            return false;
        }
        ListCollectionsResult other = (ListCollectionsResult)obj;
        if (other.getCollectionIds() == null ^ this.getCollectionIds() == null) {
            return false;
        }
        if (other.getCollectionIds() != null && !other.getCollectionIds().equals(this.getCollectionIds())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getFaceModelVersions() == null ^ this.getFaceModelVersions() == null) {
            return false;
        }
        return other.getFaceModelVersions() == null || other.getFaceModelVersions().equals(this.getFaceModelVersions());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCollectionIds() == null ? 0 : this.getCollectionIds().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getFaceModelVersions() == null ? 0 : this.getFaceModelVersions().hashCode());
        return hashCode;
    }

    public ListCollectionsResult clone() {
        try {
            return (ListCollectionsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

