/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mediapackage.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.mediapackage.model.transform.SpekeKeyProviderMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SpekeKeyProvider
implements Serializable,
Cloneable,
StructuredPojo {
    private String certificateArn;
    private String resourceId;
    private String roleArn;
    private List<String> systemIds;
    private String url;

    public void setCertificateArn(String certificateArn) {
        this.certificateArn = certificateArn;
    }

    public String getCertificateArn() {
        return this.certificateArn;
    }

    public SpekeKeyProvider withCertificateArn(String certificateArn) {
        this.setCertificateArn(certificateArn);
        return this;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public SpekeKeyProvider withResourceId(String resourceId) {
        this.setResourceId(resourceId);
        return this;
    }

    public void setRoleArn(String roleArn) {
        this.roleArn = roleArn;
    }

    public String getRoleArn() {
        return this.roleArn;
    }

    public SpekeKeyProvider withRoleArn(String roleArn) {
        this.setRoleArn(roleArn);
        return this;
    }

    public List<String> getSystemIds() {
        return this.systemIds;
    }

    public void setSystemIds(Collection<String> systemIds) {
        if (systemIds == null) {
            this.systemIds = null;
            return;
        }
        this.systemIds = new ArrayList<String>(systemIds);
    }

    public SpekeKeyProvider withSystemIds(String ... systemIds) {
        if (this.systemIds == null) {
            this.setSystemIds(new ArrayList<String>(systemIds.length));
        }
        for (String ele : systemIds) {
            this.systemIds.add(ele);
        }
        return this;
    }

    public SpekeKeyProvider withSystemIds(Collection<String> systemIds) {
        this.setSystemIds(systemIds);
        return this;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUrl() {
        return this.url;
    }

    public SpekeKeyProvider withUrl(String url) {
        this.setUrl(url);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCertificateArn() != null) {
            sb.append("CertificateArn: ").append(this.getCertificateArn()).append(",");
        }
        if (this.getResourceId() != null) {
            sb.append("ResourceId: ").append(this.getResourceId()).append(",");
        }
        if (this.getRoleArn() != null) {
            sb.append("RoleArn: ").append(this.getRoleArn()).append(",");
        }
        if (this.getSystemIds() != null) {
            sb.append("SystemIds: ").append(this.getSystemIds()).append(",");
        }
        if (this.getUrl() != null) {
            sb.append("Url: ").append(this.getUrl());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpekeKeyProvider)) {
            return false;
        }
        SpekeKeyProvider other = (SpekeKeyProvider)obj;
        if (other.getCertificateArn() == null ^ this.getCertificateArn() == null) {
            return false;
        }
        if (other.getCertificateArn() != null && !other.getCertificateArn().equals(this.getCertificateArn())) {
            return false;
        }
        if (other.getResourceId() == null ^ this.getResourceId() == null) {
            return false;
        }
        if (other.getResourceId() != null && !other.getResourceId().equals(this.getResourceId())) {
            return false;
        }
        if (other.getRoleArn() == null ^ this.getRoleArn() == null) {
            return false;
        }
        if (other.getRoleArn() != null && !other.getRoleArn().equals(this.getRoleArn())) {
            return false;
        }
        if (other.getSystemIds() == null ^ this.getSystemIds() == null) {
            return false;
        }
        if (other.getSystemIds() != null && !other.getSystemIds().equals(this.getSystemIds())) {
            return false;
        }
        if (other.getUrl() == null ^ this.getUrl() == null) {
            return false;
        }
        return other.getUrl() == null || other.getUrl().equals(this.getUrl());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCertificateArn() == null ? 0 : this.getCertificateArn().hashCode());
        hashCode = 31 * hashCode + (this.getResourceId() == null ? 0 : this.getResourceId().hashCode());
        hashCode = 31 * hashCode + (this.getRoleArn() == null ? 0 : this.getRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.getSystemIds() == null ? 0 : this.getSystemIds().hashCode());
        hashCode = 31 * hashCode + (this.getUrl() == null ? 0 : this.getUrl().hashCode());
        return hashCode;
    }

    public SpekeKeyProvider clone() {
        try {
            return (SpekeKeyProvider)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SpekeKeyProviderMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

