/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.medialive.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.medialive.model.InputSettings;
import java.util.List;

@SdkInternalApi
public class InputSettingsMarshaller {
    private static final MarshallingInfo<List> AUDIOSELECTORS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("audioSelectors").build();
    private static final MarshallingInfo<List> CAPTIONSELECTORS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("captionSelectors").build();
    private static final MarshallingInfo<String> DEBLOCKFILTER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("deblockFilter").build();
    private static final MarshallingInfo<String> DENOISEFILTER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("denoiseFilter").build();
    private static final MarshallingInfo<Integer> FILTERSTRENGTH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("filterStrength").build();
    private static final MarshallingInfo<String> INPUTFILTER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("inputFilter").build();
    private static final MarshallingInfo<StructuredPojo> NETWORKINPUTSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("networkInputSettings").build();
    private static final MarshallingInfo<String> SOURCEENDBEHAVIOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sourceEndBehavior").build();
    private static final MarshallingInfo<StructuredPojo> VIDEOSELECTOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("videoSelector").build();
    private static final InputSettingsMarshaller instance = new InputSettingsMarshaller();

    public static InputSettingsMarshaller getInstance() {
        return instance;
    }

    public void marshall(InputSettings inputSettings, ProtocolMarshaller protocolMarshaller) {
        if (inputSettings == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(inputSettings.getAudioSelectors(), AUDIOSELECTORS_BINDING);
            protocolMarshaller.marshall(inputSettings.getCaptionSelectors(), CAPTIONSELECTORS_BINDING);
            protocolMarshaller.marshall((Object)inputSettings.getDeblockFilter(), DEBLOCKFILTER_BINDING);
            protocolMarshaller.marshall((Object)inputSettings.getDenoiseFilter(), DENOISEFILTER_BINDING);
            protocolMarshaller.marshall((Object)inputSettings.getFilterStrength(), FILTERSTRENGTH_BINDING);
            protocolMarshaller.marshall((Object)inputSettings.getInputFilter(), INPUTFILTER_BINDING);
            protocolMarshaller.marshall((Object)inputSettings.getNetworkInputSettings(), NETWORKINPUTSETTINGS_BINDING);
            protocolMarshaller.marshall((Object)inputSettings.getSourceEndBehavior(), SOURCEENDBEHAVIOR_BINDING);
            protocolMarshaller.marshall((Object)inputSettings.getVideoSelector(), VIDEOSELECTOR_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

