/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mediaconvert.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.mediaconvert.model.ChannelMapping;
import java.util.List;

@SdkInternalApi
public class ChannelMappingMarshaller {
    private static final MarshallingInfo<List> OUTPUTCHANNELS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("outputChannels").build();
    private static final ChannelMappingMarshaller instance = new ChannelMappingMarshaller();

    public static ChannelMappingMarshaller getInstance() {
        return instance;
    }

    public void marshall(ChannelMapping channelMapping, ProtocolMarshaller protocolMarshaller) {
        if (channelMapping == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(channelMapping.getOutputChannels(), OUTPUTCHANNELS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

