/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mediaconvert.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.mediaconvert.model.Preset;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListPresetsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String nextToken;
    private List<Preset> presets;

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListPresetsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public List<Preset> getPresets() {
        return this.presets;
    }

    public void setPresets(Collection<Preset> presets) {
        if (presets == null) {
            this.presets = null;
            return;
        }
        this.presets = new ArrayList<Preset>(presets);
    }

    public ListPresetsResult withPresets(Preset ... presets) {
        if (this.presets == null) {
            this.setPresets(new ArrayList<Preset>(presets.length));
        }
        for (Preset ele : presets) {
            this.presets.add(ele);
        }
        return this;
    }

    public ListPresetsResult withPresets(Collection<Preset> presets) {
        this.setPresets(presets);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getPresets() != null) {
            sb.append("Presets: ").append(this.getPresets());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPresetsResult)) {
            return false;
        }
        ListPresetsResult other = (ListPresetsResult)obj;
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getPresets() == null ^ this.getPresets() == null) {
            return false;
        }
        return other.getPresets() == null || other.getPresets().equals(this.getPresets());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getPresets() == null ? 0 : this.getPresets().hashCode());
        return hashCode;
    }

    public ListPresetsResult clone() {
        try {
            return (ListPresetsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

