/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.managedblockchainquery.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.managedblockchainquery.model.TokenBalance;

@SdkInternalApi
public class TokenBalanceMarshaller {
    private static final MarshallingInfo<StructuredPojo> OWNERIDENTIFIER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ownerIdentifier").build();
    private static final MarshallingInfo<StructuredPojo> TOKENIDENTIFIER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("tokenIdentifier").build();
    private static final MarshallingInfo<String> BALANCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("balance").build();
    private static final MarshallingInfo<StructuredPojo> ATBLOCKCHAININSTANT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("atBlockchainInstant").build();
    private static final MarshallingInfo<StructuredPojo> LASTUPDATEDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastUpdatedTime").build();
    private static final TokenBalanceMarshaller instance = new TokenBalanceMarshaller();

    public static TokenBalanceMarshaller getInstance() {
        return instance;
    }

    public void marshall(TokenBalance tokenBalance, ProtocolMarshaller protocolMarshaller) {
        if (tokenBalance == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)tokenBalance.getOwnerIdentifier(), OWNERIDENTIFIER_BINDING);
            protocolMarshaller.marshall((Object)tokenBalance.getTokenIdentifier(), TOKENIDENTIFIER_BINDING);
            protocolMarshaller.marshall((Object)tokenBalance.getBalance(), BALANCE_BINDING);
            protocolMarshaller.marshall((Object)tokenBalance.getAtBlockchainInstant(), ATBLOCKCHAININSTANT_BINDING);
            protocolMarshaller.marshall((Object)tokenBalance.getLastUpdatedTime(), LASTUPDATEDTIME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

