/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.glacier.model.UploadListElement;

@SdkInternalApi
public class UploadListElementMarshaller {
    private static final MarshallingInfo<String> MULTIPARTUPLOADID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MultipartUploadId").build();
    private static final MarshallingInfo<String> VAULTARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VaultARN").build();
    private static final MarshallingInfo<String> ARCHIVEDESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ArchiveDescription").build();
    private static final MarshallingInfo<Long> PARTSIZEINBYTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PartSizeInBytes").build();
    private static final MarshallingInfo<String> CREATIONDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationDate").build();
    private static final UploadListElementMarshaller instance = new UploadListElementMarshaller();

    public static UploadListElementMarshaller getInstance() {
        return instance;
    }

    public void marshall(UploadListElement uploadListElement, ProtocolMarshaller protocolMarshaller) {
        if (uploadListElement == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)uploadListElement.getMultipartUploadId(), MULTIPARTUPLOADID_BINDING);
            protocolMarshaller.marshall((Object)uploadListElement.getVaultARN(), VAULTARN_BINDING);
            protocolMarshaller.marshall((Object)uploadListElement.getArchiveDescription(), ARCHIVEDESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)uploadListElement.getPartSizeInBytes(), PARTSIZEINBYTES_BINDING);
            protocolMarshaller.marshall((Object)uploadListElement.getCreationDate(), CREATIONDATE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

