/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticbeanstalk.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticbeanstalk.model.ConfigurationOptionSetting;
import com.amazonaws.services.elasticbeanstalk.model.S3Location;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class CreatePlatformVersionRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String platformName;
    private String platformVersion;
    private S3Location platformDefinitionBundle;
    private String environmentName;
    private SdkInternalList<ConfigurationOptionSetting> optionSettings;

    public void setPlatformName(String platformName) {
        this.platformName = platformName;
    }

    public String getPlatformName() {
        return this.platformName;
    }

    public CreatePlatformVersionRequest withPlatformName(String platformName) {
        this.setPlatformName(platformName);
        return this;
    }

    public void setPlatformVersion(String platformVersion) {
        this.platformVersion = platformVersion;
    }

    public String getPlatformVersion() {
        return this.platformVersion;
    }

    public CreatePlatformVersionRequest withPlatformVersion(String platformVersion) {
        this.setPlatformVersion(platformVersion);
        return this;
    }

    public void setPlatformDefinitionBundle(S3Location platformDefinitionBundle) {
        this.platformDefinitionBundle = platformDefinitionBundle;
    }

    public S3Location getPlatformDefinitionBundle() {
        return this.platformDefinitionBundle;
    }

    public CreatePlatformVersionRequest withPlatformDefinitionBundle(S3Location platformDefinitionBundle) {
        this.setPlatformDefinitionBundle(platformDefinitionBundle);
        return this;
    }

    public void setEnvironmentName(String environmentName) {
        this.environmentName = environmentName;
    }

    public String getEnvironmentName() {
        return this.environmentName;
    }

    public CreatePlatformVersionRequest withEnvironmentName(String environmentName) {
        this.setEnvironmentName(environmentName);
        return this;
    }

    public List<ConfigurationOptionSetting> getOptionSettings() {
        if (this.optionSettings == null) {
            this.optionSettings = new SdkInternalList();
        }
        return this.optionSettings;
    }

    public void setOptionSettings(Collection<ConfigurationOptionSetting> optionSettings) {
        if (optionSettings == null) {
            this.optionSettings = null;
            return;
        }
        this.optionSettings = new SdkInternalList(optionSettings);
    }

    public CreatePlatformVersionRequest withOptionSettings(ConfigurationOptionSetting ... optionSettings) {
        if (this.optionSettings == null) {
            this.setOptionSettings((Collection<ConfigurationOptionSetting>)new SdkInternalList(optionSettings.length));
        }
        for (ConfigurationOptionSetting ele : optionSettings) {
            this.optionSettings.add((Object)ele);
        }
        return this;
    }

    public CreatePlatformVersionRequest withOptionSettings(Collection<ConfigurationOptionSetting> optionSettings) {
        this.setOptionSettings(optionSettings);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPlatformName() != null) {
            sb.append("PlatformName: ").append(this.getPlatformName()).append(",");
        }
        if (this.getPlatformVersion() != null) {
            sb.append("PlatformVersion: ").append(this.getPlatformVersion()).append(",");
        }
        if (this.getPlatformDefinitionBundle() != null) {
            sb.append("PlatformDefinitionBundle: ").append(this.getPlatformDefinitionBundle()).append(",");
        }
        if (this.getEnvironmentName() != null) {
            sb.append("EnvironmentName: ").append(this.getEnvironmentName()).append(",");
        }
        if (this.getOptionSettings() != null) {
            sb.append("OptionSettings: ").append(this.getOptionSettings());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePlatformVersionRequest)) {
            return false;
        }
        CreatePlatformVersionRequest other = (CreatePlatformVersionRequest)obj;
        if (other.getPlatformName() == null ^ this.getPlatformName() == null) {
            return false;
        }
        if (other.getPlatformName() != null && !other.getPlatformName().equals(this.getPlatformName())) {
            return false;
        }
        if (other.getPlatformVersion() == null ^ this.getPlatformVersion() == null) {
            return false;
        }
        if (other.getPlatformVersion() != null && !other.getPlatformVersion().equals(this.getPlatformVersion())) {
            return false;
        }
        if (other.getPlatformDefinitionBundle() == null ^ this.getPlatformDefinitionBundle() == null) {
            return false;
        }
        if (other.getPlatformDefinitionBundle() != null && !other.getPlatformDefinitionBundle().equals(this.getPlatformDefinitionBundle())) {
            return false;
        }
        if (other.getEnvironmentName() == null ^ this.getEnvironmentName() == null) {
            return false;
        }
        if (other.getEnvironmentName() != null && !other.getEnvironmentName().equals(this.getEnvironmentName())) {
            return false;
        }
        if (other.getOptionSettings() == null ^ this.getOptionSettings() == null) {
            return false;
        }
        return other.getOptionSettings() == null || other.getOptionSettings().equals(this.getOptionSettings());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPlatformName() == null ? 0 : this.getPlatformName().hashCode());
        hashCode = 31 * hashCode + (this.getPlatformVersion() == null ? 0 : this.getPlatformVersion().hashCode());
        hashCode = 31 * hashCode + (this.getPlatformDefinitionBundle() == null ? 0 : this.getPlatformDefinitionBundle().hashCode());
        hashCode = 31 * hashCode + (this.getEnvironmentName() == null ? 0 : this.getEnvironmentName().hashCode());
        hashCode = 31 * hashCode + (this.getOptionSettings() == null ? 0 : this.getOptionSettings().hashCode());
        return hashCode;
    }

    public CreatePlatformVersionRequest clone() {
        return (CreatePlatformVersionRequest)super.clone();
    }
}

