/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ecs.model.Attribute;
import com.amazonaws.services.ecs.model.Resource;
import com.amazonaws.services.ecs.model.Tag;
import com.amazonaws.services.ecs.model.VersionInfo;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class RegisterContainerInstanceRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String cluster;
    private String instanceIdentityDocument;
    private String instanceIdentityDocumentSignature;
    private SdkInternalList<Resource> totalResources;
    private VersionInfo versionInfo;
    private String containerInstanceArn;
    private SdkInternalList<Attribute> attributes;
    private SdkInternalList<Tag> tags;

    public void setCluster(String cluster) {
        this.cluster = cluster;
    }

    public String getCluster() {
        return this.cluster;
    }

    public RegisterContainerInstanceRequest withCluster(String cluster) {
        this.setCluster(cluster);
        return this;
    }

    public void setInstanceIdentityDocument(String instanceIdentityDocument) {
        this.instanceIdentityDocument = instanceIdentityDocument;
    }

    public String getInstanceIdentityDocument() {
        return this.instanceIdentityDocument;
    }

    public RegisterContainerInstanceRequest withInstanceIdentityDocument(String instanceIdentityDocument) {
        this.setInstanceIdentityDocument(instanceIdentityDocument);
        return this;
    }

    public void setInstanceIdentityDocumentSignature(String instanceIdentityDocumentSignature) {
        this.instanceIdentityDocumentSignature = instanceIdentityDocumentSignature;
    }

    public String getInstanceIdentityDocumentSignature() {
        return this.instanceIdentityDocumentSignature;
    }

    public RegisterContainerInstanceRequest withInstanceIdentityDocumentSignature(String instanceIdentityDocumentSignature) {
        this.setInstanceIdentityDocumentSignature(instanceIdentityDocumentSignature);
        return this;
    }

    public List<Resource> getTotalResources() {
        if (this.totalResources == null) {
            this.totalResources = new SdkInternalList();
        }
        return this.totalResources;
    }

    public void setTotalResources(Collection<Resource> totalResources) {
        if (totalResources == null) {
            this.totalResources = null;
            return;
        }
        this.totalResources = new SdkInternalList(totalResources);
    }

    public RegisterContainerInstanceRequest withTotalResources(Resource ... totalResources) {
        if (this.totalResources == null) {
            this.setTotalResources((Collection<Resource>)new SdkInternalList(totalResources.length));
        }
        for (Resource ele : totalResources) {
            this.totalResources.add((Object)ele);
        }
        return this;
    }

    public RegisterContainerInstanceRequest withTotalResources(Collection<Resource> totalResources) {
        this.setTotalResources(totalResources);
        return this;
    }

    public void setVersionInfo(VersionInfo versionInfo) {
        this.versionInfo = versionInfo;
    }

    public VersionInfo getVersionInfo() {
        return this.versionInfo;
    }

    public RegisterContainerInstanceRequest withVersionInfo(VersionInfo versionInfo) {
        this.setVersionInfo(versionInfo);
        return this;
    }

    public void setContainerInstanceArn(String containerInstanceArn) {
        this.containerInstanceArn = containerInstanceArn;
    }

    public String getContainerInstanceArn() {
        return this.containerInstanceArn;
    }

    public RegisterContainerInstanceRequest withContainerInstanceArn(String containerInstanceArn) {
        this.setContainerInstanceArn(containerInstanceArn);
        return this;
    }

    public List<Attribute> getAttributes() {
        if (this.attributes == null) {
            this.attributes = new SdkInternalList();
        }
        return this.attributes;
    }

    public void setAttributes(Collection<Attribute> attributes) {
        if (attributes == null) {
            this.attributes = null;
            return;
        }
        this.attributes = new SdkInternalList(attributes);
    }

    public RegisterContainerInstanceRequest withAttributes(Attribute ... attributes) {
        if (this.attributes == null) {
            this.setAttributes((Collection<Attribute>)new SdkInternalList(attributes.length));
        }
        for (Attribute ele : attributes) {
            this.attributes.add((Object)ele);
        }
        return this;
    }

    public RegisterContainerInstanceRequest withAttributes(Collection<Attribute> attributes) {
        this.setAttributes(attributes);
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new SdkInternalList();
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new SdkInternalList(tags);
    }

    public RegisterContainerInstanceRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags((Collection<Tag>)new SdkInternalList(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add((Object)ele);
        }
        return this;
    }

    public RegisterContainerInstanceRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCluster() != null) {
            sb.append("Cluster: ").append(this.getCluster()).append(",");
        }
        if (this.getInstanceIdentityDocument() != null) {
            sb.append("InstanceIdentityDocument: ").append(this.getInstanceIdentityDocument()).append(",");
        }
        if (this.getInstanceIdentityDocumentSignature() != null) {
            sb.append("InstanceIdentityDocumentSignature: ").append(this.getInstanceIdentityDocumentSignature()).append(",");
        }
        if (this.getTotalResources() != null) {
            sb.append("TotalResources: ").append(this.getTotalResources()).append(",");
        }
        if (this.getVersionInfo() != null) {
            sb.append("VersionInfo: ").append(this.getVersionInfo()).append(",");
        }
        if (this.getContainerInstanceArn() != null) {
            sb.append("ContainerInstanceArn: ").append(this.getContainerInstanceArn()).append(",");
        }
        if (this.getAttributes() != null) {
            sb.append("Attributes: ").append(this.getAttributes()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterContainerInstanceRequest)) {
            return false;
        }
        RegisterContainerInstanceRequest other = (RegisterContainerInstanceRequest)obj;
        if (other.getCluster() == null ^ this.getCluster() == null) {
            return false;
        }
        if (other.getCluster() != null && !other.getCluster().equals(this.getCluster())) {
            return false;
        }
        if (other.getInstanceIdentityDocument() == null ^ this.getInstanceIdentityDocument() == null) {
            return false;
        }
        if (other.getInstanceIdentityDocument() != null && !other.getInstanceIdentityDocument().equals(this.getInstanceIdentityDocument())) {
            return false;
        }
        if (other.getInstanceIdentityDocumentSignature() == null ^ this.getInstanceIdentityDocumentSignature() == null) {
            return false;
        }
        if (other.getInstanceIdentityDocumentSignature() != null && !other.getInstanceIdentityDocumentSignature().equals(this.getInstanceIdentityDocumentSignature())) {
            return false;
        }
        if (other.getTotalResources() == null ^ this.getTotalResources() == null) {
            return false;
        }
        if (other.getTotalResources() != null && !other.getTotalResources().equals(this.getTotalResources())) {
            return false;
        }
        if (other.getVersionInfo() == null ^ this.getVersionInfo() == null) {
            return false;
        }
        if (other.getVersionInfo() != null && !other.getVersionInfo().equals(this.getVersionInfo())) {
            return false;
        }
        if (other.getContainerInstanceArn() == null ^ this.getContainerInstanceArn() == null) {
            return false;
        }
        if (other.getContainerInstanceArn() != null && !other.getContainerInstanceArn().equals(this.getContainerInstanceArn())) {
            return false;
        }
        if (other.getAttributes() == null ^ this.getAttributes() == null) {
            return false;
        }
        if (other.getAttributes() != null && !other.getAttributes().equals(this.getAttributes())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCluster() == null ? 0 : this.getCluster().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceIdentityDocument() == null ? 0 : this.getInstanceIdentityDocument().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceIdentityDocumentSignature() == null ? 0 : this.getInstanceIdentityDocumentSignature().hashCode());
        hashCode = 31 * hashCode + (this.getTotalResources() == null ? 0 : this.getTotalResources().hashCode());
        hashCode = 31 * hashCode + (this.getVersionInfo() == null ? 0 : this.getVersionInfo().hashCode());
        hashCode = 31 * hashCode + (this.getContainerInstanceArn() == null ? 0 : this.getContainerInstanceArn().hashCode());
        hashCode = 31 * hashCode + (this.getAttributes() == null ? 0 : this.getAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public RegisterContainerInstanceRequest clone() {
        return (RegisterContainerInstanceRequest)super.clone();
    }
}

