/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.devicefarm.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.devicefarm.model.MonetaryAmount;

@SdkInternalApi
public class MonetaryAmountMarshaller {
    private static final MarshallingInfo<Double> AMOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("amount").build();
    private static final MarshallingInfo<String> CURRENCYCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("currencyCode").build();
    private static final MonetaryAmountMarshaller instance = new MonetaryAmountMarshaller();

    public static MonetaryAmountMarshaller getInstance() {
        return instance;
    }

    public void marshall(MonetaryAmount monetaryAmount, ProtocolMarshaller protocolMarshaller) {
        if (monetaryAmount == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)monetaryAmount.getAmount(), AMOUNT_BINDING);
            protocolMarshaller.marshall((Object)monetaryAmount.getCurrencyCode(), CURRENCYCODE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

