/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.devicefarm.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.devicefarm.model.Sample;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListSamplesResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<Sample> samples;
    private String nextToken;

    public List<Sample> getSamples() {
        return this.samples;
    }

    public void setSamples(Collection<Sample> samples) {
        if (samples == null) {
            this.samples = null;
            return;
        }
        this.samples = new ArrayList<Sample>(samples);
    }

    public ListSamplesResult withSamples(Sample ... samples) {
        if (this.samples == null) {
            this.setSamples(new ArrayList<Sample>(samples.length));
        }
        for (Sample ele : samples) {
            this.samples.add(ele);
        }
        return this;
    }

    public ListSamplesResult withSamples(Collection<Sample> samples) {
        this.setSamples(samples);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListSamplesResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSamples() != null) {
            sb.append("Samples: ").append(this.getSamples()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSamplesResult)) {
            return false;
        }
        ListSamplesResult other = (ListSamplesResult)obj;
        if (other.getSamples() == null ^ this.getSamples() == null) {
            return false;
        }
        if (other.getSamples() != null && !other.getSamples().equals(this.getSamples())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSamples() == null ? 0 : this.getSamples().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListSamplesResult clone() {
        try {
            return (ListSamplesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

