/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.deadline.model.transform;

import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.deadline.model.*;

import com.amazonaws.protocol.*;
import com.amazonaws.annotation.SdkInternalApi;

/**
 * SessionActionDefinitionMarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
@SdkInternalApi
public class SessionActionDefinitionMarshaller {

    private static final MarshallingInfo<StructuredPojo> ENVENTER_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("envEnter").build();
    private static final MarshallingInfo<StructuredPojo> ENVEXIT_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("envExit").build();
    private static final MarshallingInfo<StructuredPojo> SYNCINPUTJOBATTACHMENTS_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("syncInputJobAttachments").build();
    private static final MarshallingInfo<StructuredPojo> TASKRUN_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("taskRun").build();

    private static final SessionActionDefinitionMarshaller instance = new SessionActionDefinitionMarshaller();

    public static SessionActionDefinitionMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(SessionActionDefinition sessionActionDefinition, ProtocolMarshaller protocolMarshaller) {

        if (sessionActionDefinition == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            protocolMarshaller.marshall(sessionActionDefinition.getEnvEnter(), ENVENTER_BINDING);
            protocolMarshaller.marshall(sessionActionDefinition.getEnvExit(), ENVEXIT_BINDING);
            protocolMarshaller.marshall(sessionActionDefinition.getSyncInputJobAttachments(), SYNCINPUTJOBATTACHMENTS_BINDING);
            protocolMarshaller.marshall(sessionActionDefinition.getTaskRun(), TASKRUN_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
