/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.config.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.config.model.ResourceIdentifier;
import java.util.Date;

@SdkInternalApi
public class ResourceIdentifierMarshaller {
    private static final MarshallingInfo<String> RESOURCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resourceType").build();
    private static final MarshallingInfo<String> RESOURCEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resourceId").build();
    private static final MarshallingInfo<String> RESOURCENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resourceName").build();
    private static final MarshallingInfo<Date> RESOURCEDELETIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resourceDeletionTime").timestampFormat("unixTimestamp").build();
    private static final ResourceIdentifierMarshaller instance = new ResourceIdentifierMarshaller();

    public static ResourceIdentifierMarshaller getInstance() {
        return instance;
    }

    public void marshall(ResourceIdentifier resourceIdentifier, ProtocolMarshaller protocolMarshaller) {
        if (resourceIdentifier == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)resourceIdentifier.getResourceType(), RESOURCETYPE_BINDING);
            protocolMarshaller.marshall((Object)resourceIdentifier.getResourceId(), RESOURCEID_BINDING);
            protocolMarshaller.marshall((Object)resourceIdentifier.getResourceName(), RESOURCENAME_BINDING);
            protocolMarshaller.marshall((Object)resourceIdentifier.getResourceDeletionTime(), RESOURCEDELETIONTIME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

