/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.comprehend.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.comprehend.model.ClassifierMetadata;

@SdkInternalApi
public class ClassifierMetadataMarshaller {
    private static final MarshallingInfo<Integer> NUMBEROFLABELS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NumberOfLabels").build();
    private static final MarshallingInfo<Integer> NUMBEROFTRAINEDDOCUMENTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NumberOfTrainedDocuments").build();
    private static final MarshallingInfo<Integer> NUMBEROFTESTDOCUMENTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NumberOfTestDocuments").build();
    private static final MarshallingInfo<StructuredPojo> EVALUATIONMETRICS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EvaluationMetrics").build();
    private static final ClassifierMetadataMarshaller instance = new ClassifierMetadataMarshaller();

    public static ClassifierMetadataMarshaller getInstance() {
        return instance;
    }

    public void marshall(ClassifierMetadata classifierMetadata, ProtocolMarshaller protocolMarshaller) {
        if (classifierMetadata == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)classifierMetadata.getNumberOfLabels(), NUMBEROFLABELS_BINDING);
            protocolMarshaller.marshall((Object)classifierMetadata.getNumberOfTrainedDocuments(), NUMBEROFTRAINEDDOCUMENTS_BINDING);
            protocolMarshaller.marshall((Object)classifierMetadata.getNumberOfTestDocuments(), NUMBEROFTESTDOCUMENTS_BINDING);
            protocolMarshaller.marshall((Object)classifierMetadata.getEvaluationMetrics(), EVALUATIONMETRICS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

