/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidp.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.cognitoidp.model.ProviderDescription;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListIdentityProvidersResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<ProviderDescription> providers;
    private String nextToken;

    public List<ProviderDescription> getProviders() {
        return this.providers;
    }

    public void setProviders(Collection<ProviderDescription> providers) {
        if (providers == null) {
            this.providers = null;
            return;
        }
        this.providers = new ArrayList<ProviderDescription>(providers);
    }

    public ListIdentityProvidersResult withProviders(ProviderDescription ... providers) {
        if (this.providers == null) {
            this.setProviders(new ArrayList<ProviderDescription>(providers.length));
        }
        for (ProviderDescription ele : providers) {
            this.providers.add(ele);
        }
        return this;
    }

    public ListIdentityProvidersResult withProviders(Collection<ProviderDescription> providers) {
        this.setProviders(providers);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListIdentityProvidersResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getProviders() != null) {
            sb.append("Providers: ").append(this.getProviders()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListIdentityProvidersResult)) {
            return false;
        }
        ListIdentityProvidersResult other = (ListIdentityProvidersResult)obj;
        if (other.getProviders() == null ^ this.getProviders() == null) {
            return false;
        }
        if (other.getProviders() != null && !other.getProviders().equals(this.getProviders())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getProviders() == null ? 0 : this.getProviders().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListIdentityProvidersResult clone() {
        try {
            return (ListIdentityProvidersResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

