/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codepipeline.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.codepipeline.model.WebhookAuthConfiguration;
import com.amazonaws.services.codepipeline.model.WebhookAuthenticationType;
import com.amazonaws.services.codepipeline.model.WebhookFilterRule;
import com.amazonaws.services.codepipeline.model.transform.WebhookDefinitionMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class WebhookDefinition
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private String targetPipeline;
    private String targetAction;
    private List<WebhookFilterRule> filters;
    private String authentication;
    private WebhookAuthConfiguration authenticationConfiguration;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public WebhookDefinition withName(String name) {
        this.setName(name);
        return this;
    }

    public void setTargetPipeline(String targetPipeline) {
        this.targetPipeline = targetPipeline;
    }

    public String getTargetPipeline() {
        return this.targetPipeline;
    }

    public WebhookDefinition withTargetPipeline(String targetPipeline) {
        this.setTargetPipeline(targetPipeline);
        return this;
    }

    public void setTargetAction(String targetAction) {
        this.targetAction = targetAction;
    }

    public String getTargetAction() {
        return this.targetAction;
    }

    public WebhookDefinition withTargetAction(String targetAction) {
        this.setTargetAction(targetAction);
        return this;
    }

    public List<WebhookFilterRule> getFilters() {
        return this.filters;
    }

    public void setFilters(Collection<WebhookFilterRule> filters) {
        if (filters == null) {
            this.filters = null;
            return;
        }
        this.filters = new ArrayList<WebhookFilterRule>(filters);
    }

    public WebhookDefinition withFilters(WebhookFilterRule ... filters) {
        if (this.filters == null) {
            this.setFilters(new ArrayList<WebhookFilterRule>(filters.length));
        }
        for (WebhookFilterRule ele : filters) {
            this.filters.add(ele);
        }
        return this;
    }

    public WebhookDefinition withFilters(Collection<WebhookFilterRule> filters) {
        this.setFilters(filters);
        return this;
    }

    public void setAuthentication(String authentication) {
        this.authentication = authentication;
    }

    public String getAuthentication() {
        return this.authentication;
    }

    public WebhookDefinition withAuthentication(String authentication) {
        this.setAuthentication(authentication);
        return this;
    }

    public WebhookDefinition withAuthentication(WebhookAuthenticationType authentication) {
        this.authentication = authentication.toString();
        return this;
    }

    public void setAuthenticationConfiguration(WebhookAuthConfiguration authenticationConfiguration) {
        this.authenticationConfiguration = authenticationConfiguration;
    }

    public WebhookAuthConfiguration getAuthenticationConfiguration() {
        return this.authenticationConfiguration;
    }

    public WebhookDefinition withAuthenticationConfiguration(WebhookAuthConfiguration authenticationConfiguration) {
        this.setAuthenticationConfiguration(authenticationConfiguration);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getTargetPipeline() != null) {
            sb.append("TargetPipeline: ").append(this.getTargetPipeline()).append(",");
        }
        if (this.getTargetAction() != null) {
            sb.append("TargetAction: ").append(this.getTargetAction()).append(",");
        }
        if (this.getFilters() != null) {
            sb.append("Filters: ").append(this.getFilters()).append(",");
        }
        if (this.getAuthentication() != null) {
            sb.append("Authentication: ").append(this.getAuthentication()).append(",");
        }
        if (this.getAuthenticationConfiguration() != null) {
            sb.append("AuthenticationConfiguration: ").append(this.getAuthenticationConfiguration());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WebhookDefinition)) {
            return false;
        }
        WebhookDefinition other = (WebhookDefinition)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getTargetPipeline() == null ^ this.getTargetPipeline() == null) {
            return false;
        }
        if (other.getTargetPipeline() != null && !other.getTargetPipeline().equals(this.getTargetPipeline())) {
            return false;
        }
        if (other.getTargetAction() == null ^ this.getTargetAction() == null) {
            return false;
        }
        if (other.getTargetAction() != null && !other.getTargetAction().equals(this.getTargetAction())) {
            return false;
        }
        if (other.getFilters() == null ^ this.getFilters() == null) {
            return false;
        }
        if (other.getFilters() != null && !other.getFilters().equals(this.getFilters())) {
            return false;
        }
        if (other.getAuthentication() == null ^ this.getAuthentication() == null) {
            return false;
        }
        if (other.getAuthentication() != null && !other.getAuthentication().equals(this.getAuthentication())) {
            return false;
        }
        if (other.getAuthenticationConfiguration() == null ^ this.getAuthenticationConfiguration() == null) {
            return false;
        }
        return other.getAuthenticationConfiguration() == null || other.getAuthenticationConfiguration().equals(this.getAuthenticationConfiguration());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getTargetPipeline() == null ? 0 : this.getTargetPipeline().hashCode());
        hashCode = 31 * hashCode + (this.getTargetAction() == null ? 0 : this.getTargetAction().hashCode());
        hashCode = 31 * hashCode + (this.getFilters() == null ? 0 : this.getFilters().hashCode());
        hashCode = 31 * hashCode + (this.getAuthentication() == null ? 0 : this.getAuthentication().hashCode());
        hashCode = 31 * hashCode + (this.getAuthenticationConfiguration() == null ? 0 : this.getAuthenticationConfiguration().hashCode());
        return hashCode;
    }

    public WebhookDefinition clone() {
        try {
            return (WebhookDefinition)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        WebhookDefinitionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

