/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatch.waiters;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.services.cloudwatch.AmazonCloudWatch;
import com.amazonaws.services.cloudwatch.model.DescribeAlarmsRequest;
import com.amazonaws.services.cloudwatch.waiters.AlarmExists;
import com.amazonaws.services.cloudwatch.waiters.CompositeAlarmExists;
import com.amazonaws.services.cloudwatch.waiters.DescribeAlarmsFunction;
import com.amazonaws.waiters.FixedDelayStrategy;
import com.amazonaws.waiters.MaxAttemptsRetryStrategy;
import com.amazonaws.waiters.PollingStrategy;
import com.amazonaws.waiters.SdkFunction;
import com.amazonaws.waiters.Waiter;
import com.amazonaws.waiters.WaiterAcceptor;
import com.amazonaws.waiters.WaiterBuilder;
import com.amazonaws.waiters.WaiterExecutorServiceFactory;
import java.util.concurrent.ExecutorService;

public class AmazonCloudWatchWaiters {
    private final AmazonCloudWatch client;
    private final ExecutorService executorService = WaiterExecutorServiceFactory.buildExecutorServiceForWaiter((String)"AmazonCloudWatchWaiters");

    @SdkInternalApi
    public AmazonCloudWatchWaiters(AmazonCloudWatch client) {
        this.client = client;
    }

    public Waiter<DescribeAlarmsRequest> alarmExists() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeAlarmsFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new AlarmExists.IsTrueMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(40), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(5))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeAlarmsRequest> compositeAlarmExists() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeAlarmsFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new CompositeAlarmExists.IsTrueMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(40), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(5))).withExecutorService(this.executorService).build();
    }

    public void shutdown() {
        this.executorService.shutdown();
    }
}

