/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.services.cloudfront.model.EndPoint;
import com.amazonaws.services.cloudfront.model.transform.KinesisStreamConfigStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class EndPointStaxUnmarshaller
implements Unmarshaller<EndPoint, StaxUnmarshallerContext> {
    private static EndPointStaxUnmarshaller instance;

    public EndPoint unmarshall(StaxUnmarshallerContext context) throws Exception {
        EndPoint endPoint = new EndPoint();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return endPoint;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("StreamType", targetDepth)) {
                    endPoint.setStreamType(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("KinesisStreamConfig", targetDepth)) continue;
                endPoint.setKinesisStreamConfig(KinesisStreamConfigStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return endPoint;
    }

    public static EndPointStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new EndPointStaxUnmarshaller();
        }
        return instance;
    }
}

