/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.services.cloudfront.model.ConflictingAlias;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class ConflictingAliasStaxUnmarshaller
implements Unmarshaller<ConflictingAlias, StaxUnmarshallerContext> {
    private static ConflictingAliasStaxUnmarshaller instance;

    public ConflictingAlias unmarshall(StaxUnmarshallerContext context) throws Exception {
        ConflictingAlias conflictingAlias = new ConflictingAlias();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return conflictingAlias;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Alias", targetDepth)) {
                    conflictingAlias.setAlias(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("DistributionId", targetDepth)) {
                    conflictingAlias.setDistributionId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("AccountId", targetDepth)) continue;
                conflictingAlias.setAccountId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return conflictingAlias;
    }

    public static ConflictingAliasStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new ConflictingAliasStaxUnmarshaller();
        }
        return instance;
    }
}

