/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.mgn;

import javax.annotation.Generated;

import com.amazonaws.services.mgn.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AWSmgn}. Convenient method forms pass through to the corresponding overload that
 * takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAWSmgn implements AWSmgn {

    protected AbstractAWSmgn() {
    }

    @Override
    public ArchiveApplicationResult archiveApplication(ArchiveApplicationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ArchiveWaveResult archiveWave(ArchiveWaveRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public AssociateApplicationsResult associateApplications(AssociateApplicationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public AssociateSourceServersResult associateSourceServers(AssociateSourceServersRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ChangeServerLifeCycleStateResult changeServerLifeCycleState(ChangeServerLifeCycleStateRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateApplicationResult createApplication(CreateApplicationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateConnectorResult createConnector(CreateConnectorRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateLaunchConfigurationTemplateResult createLaunchConfigurationTemplate(CreateLaunchConfigurationTemplateRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateReplicationConfigurationTemplateResult createReplicationConfigurationTemplate(CreateReplicationConfigurationTemplateRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateWaveResult createWave(CreateWaveRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteApplicationResult deleteApplication(DeleteApplicationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteConnectorResult deleteConnector(DeleteConnectorRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteJobResult deleteJob(DeleteJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteLaunchConfigurationTemplateResult deleteLaunchConfigurationTemplate(DeleteLaunchConfigurationTemplateRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteReplicationConfigurationTemplateResult deleteReplicationConfigurationTemplate(DeleteReplicationConfigurationTemplateRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteSourceServerResult deleteSourceServer(DeleteSourceServerRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteVcenterClientResult deleteVcenterClient(DeleteVcenterClientRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteWaveResult deleteWave(DeleteWaveRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeJobLogItemsResult describeJobLogItems(DescribeJobLogItemsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeJobsResult describeJobs(DescribeJobsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeLaunchConfigurationTemplatesResult describeLaunchConfigurationTemplates(DescribeLaunchConfigurationTemplatesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeReplicationConfigurationTemplatesResult describeReplicationConfigurationTemplates(DescribeReplicationConfigurationTemplatesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeSourceServersResult describeSourceServers(DescribeSourceServersRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeVcenterClientsResult describeVcenterClients(DescribeVcenterClientsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DisassociateApplicationsResult disassociateApplications(DisassociateApplicationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DisassociateSourceServersResult disassociateSourceServers(DisassociateSourceServersRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DisconnectFromServiceResult disconnectFromService(DisconnectFromServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public FinalizeCutoverResult finalizeCutover(FinalizeCutoverRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetLaunchConfigurationResult getLaunchConfiguration(GetLaunchConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetReplicationConfigurationResult getReplicationConfiguration(GetReplicationConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public InitializeServiceResult initializeService(InitializeServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListApplicationsResult listApplications(ListApplicationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListConnectorsResult listConnectors(ListConnectorsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListExportErrorsResult listExportErrors(ListExportErrorsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListExportsResult listExports(ListExportsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListImportErrorsResult listImportErrors(ListImportErrorsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListImportsResult listImports(ListImportsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListManagedAccountsResult listManagedAccounts(ListManagedAccountsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListSourceServerActionsResult listSourceServerActions(ListSourceServerActionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTemplateActionsResult listTemplateActions(ListTemplateActionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListWavesResult listWaves(ListWavesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public MarkAsArchivedResult markAsArchived(MarkAsArchivedRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PauseReplicationResult pauseReplication(PauseReplicationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PutSourceServerActionResult putSourceServerAction(PutSourceServerActionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PutTemplateActionResult putTemplateAction(PutTemplateActionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public RemoveSourceServerActionResult removeSourceServerAction(RemoveSourceServerActionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public RemoveTemplateActionResult removeTemplateAction(RemoveTemplateActionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ResumeReplicationResult resumeReplication(ResumeReplicationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public RetryDataReplicationResult retryDataReplication(RetryDataReplicationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartCutoverResult startCutover(StartCutoverRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartExportResult startExport(StartExportRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartImportResult startImport(StartImportRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartReplicationResult startReplication(StartReplicationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartTestResult startTest(StartTestRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StopReplicationResult stopReplication(StopReplicationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TerminateTargetInstancesResult terminateTargetInstances(TerminateTargetInstancesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UnarchiveApplicationResult unarchiveApplication(UnarchiveApplicationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UnarchiveWaveResult unarchiveWave(UnarchiveWaveRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateApplicationResult updateApplication(UpdateApplicationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateConnectorResult updateConnector(UpdateConnectorRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateLaunchConfigurationResult updateLaunchConfiguration(UpdateLaunchConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateLaunchConfigurationTemplateResult updateLaunchConfigurationTemplate(UpdateLaunchConfigurationTemplateRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateReplicationConfigurationResult updateReplicationConfiguration(UpdateReplicationConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateReplicationConfigurationTemplateResult updateReplicationConfigurationTemplate(UpdateReplicationConfigurationTemplateRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateSourceServerResult updateSourceServer(UpdateSourceServerRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateSourceServerReplicationTypeResult updateSourceServerReplicationType(UpdateSourceServerReplicationTypeRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateWaveResult updateWave(UpdateWaveRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
