/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.codegurusecurity.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Information about a scan with open findings.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codeguru-security-2018-05-10/ScanNameWithFindingNum"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ScanNameWithFindingNum implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The number of open findings generated by a scan.
     * </p>
     */
    private Integer findingNumber;
    /**
     * <p>
     * The name of the scan.
     * </p>
     */
    private String scanName;

    /**
     * <p>
     * The number of open findings generated by a scan.
     * </p>
     * 
     * @param findingNumber
     *        The number of open findings generated by a scan.
     */

    public void setFindingNumber(Integer findingNumber) {
        this.findingNumber = findingNumber;
    }

    /**
     * <p>
     * The number of open findings generated by a scan.
     * </p>
     * 
     * @return The number of open findings generated by a scan.
     */

    public Integer getFindingNumber() {
        return this.findingNumber;
    }

    /**
     * <p>
     * The number of open findings generated by a scan.
     * </p>
     * 
     * @param findingNumber
     *        The number of open findings generated by a scan.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ScanNameWithFindingNum withFindingNumber(Integer findingNumber) {
        setFindingNumber(findingNumber);
        return this;
    }

    /**
     * <p>
     * The name of the scan.
     * </p>
     * 
     * @param scanName
     *        The name of the scan.
     */

    public void setScanName(String scanName) {
        this.scanName = scanName;
    }

    /**
     * <p>
     * The name of the scan.
     * </p>
     * 
     * @return The name of the scan.
     */

    public String getScanName() {
        return this.scanName;
    }

    /**
     * <p>
     * The name of the scan.
     * </p>
     * 
     * @param scanName
     *        The name of the scan.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ScanNameWithFindingNum withScanName(String scanName) {
        setScanName(scanName);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getFindingNumber() != null)
            sb.append("FindingNumber: ").append(getFindingNumber()).append(",");
        if (getScanName() != null)
            sb.append("ScanName: ").append(getScanName());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof ScanNameWithFindingNum == false)
            return false;
        ScanNameWithFindingNum other = (ScanNameWithFindingNum) obj;
        if (other.getFindingNumber() == null ^ this.getFindingNumber() == null)
            return false;
        if (other.getFindingNumber() != null && other.getFindingNumber().equals(this.getFindingNumber()) == false)
            return false;
        if (other.getScanName() == null ^ this.getScanName() == null)
            return false;
        if (other.getScanName() != null && other.getScanName().equals(this.getScanName()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getFindingNumber() == null) ? 0 : getFindingNumber().hashCode());
        hashCode = prime * hashCode + ((getScanName() == null) ? 0 : getScanName().hashCode());
        return hashCode;
    }

    @Override
    public ScanNameWithFindingNum clone() {
        try {
            return (ScanNameWithFindingNum) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.codegurusecurity.model.transform.ScanNameWithFindingNumMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
